/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ASSaverNormalizeVisitor;

public abstract class AbstractASSaver {
    protected final @NonNull Resource resource;
    private Map<@NonNull Resource, @NonNull ASSaverNormalizeVisitor> resource2normalizeVisitor = null;

    protected AbstractASSaver(@NonNull Resource resource) {
        this.resource = resource;
    }

    protected @NonNull ASSaverNormalizeVisitor getNormalizeVisitor(@NonNull EObject eObject) {
        ASSaverNormalizeVisitor visitor;
        Resource resource = eObject.eResource();
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverNormalizeVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        if (this.resource2normalizeVisitor == null) {
            this.resource2normalizeVisitor = new HashMap<Resource, ASSaverNormalizeVisitor>();
        }
        if ((visitor = this.resource2normalizeVisitor.get(resource)) != null) {
            return visitor;
        }
        if (resource instanceof ASResource) {
            ASResource asResource = (ASResource)resource;
            visitor = asResource.getASResourceFactory().createASSaverNormalizeVisitor(this);
            this.resource2normalizeVisitor.put(resource, visitor);
            return visitor;
        }
        throw new IllegalStateException("Cannot locate " + ASSaverNormalizeVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    public void normalizeContents() {
        ArrayList<@NonNull EObject> allContents = new ArrayList<EObject>();
        @NonNull TreeIterator tit = this.resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Visitable)) continue;
            allContents.add(eObject);
        }
        HashMap<EClass, @NonNull ASSaverNormalizeVisitor> eClass2normalizeVisitor = new HashMap<EClass, ASSaverNormalizeVisitor>();
        for (EObject eObject : allContents) {
            EClass eClass = eObject.eClass();
            ASSaverNormalizeVisitor normalizeVisitor = (ASSaverNormalizeVisitor)eClass2normalizeVisitor.get(eClass);
            if (normalizeVisitor == null) {
                normalizeVisitor = this.getNormalizeVisitor(eObject);
                eClass2normalizeVisitor.put(eClass, normalizeVisitor);
            }
            normalizeVisitor.safeVisit((Visitable)eObject);
        }
    }
}

