/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.helper.tests;

import java.util.List;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.ecore.helper.tests.AbstractTestSuite;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;

public class RegressionTest
extends AbstractTestSuite {
    public void test_completionOfRightmostSubexpression_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEReference());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eOpposite = self.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "eOpposite");
    }

    public void test_completionOfRightmost_parentheses_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEReference());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(self.eOpposite = self).");
        this.assertNotChoice(choices, ChoiceKind.PROPERTY, "eOpposite");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsUndefined");
    }

    public void test_completionOnLetVariable_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "let p : EPackage = self.ePackage in 'foo_'.concat(p.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "eClassifiers");
    }

    public void test_completionOnLetExpression_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(let p : EPackage = self.ePackage in p.name).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "toLower");
    }

    public void test_completionOnIteratorVariable_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuperTypes->collect(i : EClass | i.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "ePackage");
    }

    public void test_completionOnAccumulator_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuperTypes->iterate(i : EClass; a : String = '' | a.");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuperTypes->iterate(i : EClass; a : String = '' | a.concat(i.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "name");
    }

    public void test_completionOnIterate_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuperTypes->iterate(i : EClass; a : String = '' | a.concat(i.name)).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
    }

    public void test_completionOnIterator_sequence_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Sequence{'abc', 'a', 'ab'}->");
        this.assertChoice(choices, ChoiceKind.OPERATION, "subSequence");
    }

    public void test_completionOnIterator_orderedSet_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuperTypes->select(i : EClass | i.eSuperTypes->isEmpty())->");
        this.assertChoice(choices, ChoiceKind.OPERATION, "subOrderedSet");
    }

    public void test_completionOnIterator_bag_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Set{'abc', 'a', 'ab'}->collect(i : String | i.size())->");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "symmetricDifference");
    }

    public void test_completionOnIfExpression_RATLC00537918() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(if true then 'a' else 'b' endif).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if true then 'a' else 'b' endif.");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "concat");
    }

    public void test_variables_RATLC00535552() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "let pkgName : String = ePackage.name in");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "pkgName");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "eSuperTypes");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclAsType");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "eSuperTypes->collect(st : EClass | ");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "st");
    }

    public void test_parameters_RATLC00535552() {
        this.helper.setOperationContext((Object)this.apple, (Object)this.apple_labelOper);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "'' <> ");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "text");
    }

    public void test_partial_property_RATLC00535552() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.eSuper");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "eSuperTypes");
        this.assertNotChoice(choices, ChoiceKind.PROPERTY, "ePackage");
    }

    public void test_partial_operation_RATLC00535552() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClass());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIs");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsUndefined");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclAsType");
    }

    public void test_partial_type_RATLC00535552() {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClassifier());
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if self.oclIsKindOf(ecore::ECl");
        this.assertChoice(choices, ChoiceKind.TYPE, "EClass");
        this.assertNotChoice(choices, ChoiceKind.TYPE, "EEnum");
    }

    public void test_partial_enumLiteral_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if color <> Color::bl");
        this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "black");
        this.assertNotChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "red");
    }

    public void test_partial_collectionOperation_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->symm");
        this.assertChoice(choices, ChoiceKind.OPERATION, "symmetricDifference");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "collect");
    }

    public void test_emptyExpression_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "stem");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
    }

    public void test_garbageExpression_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "{@grr!");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "stem");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
    }

    public void test_oclIsNewOnlyInPostconditions_116664() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        this.helper.setOperationContext((Object)this.apple, (Object)this.apple_newApple);
        choices = this.helper.getSyntaxHelp(ConstraintKind.PRECONDITION, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        choices = this.helper.getSyntaxHelp(ConstraintKind.BODYCONDITION, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self.ocl");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
    }
}

