/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.FeatureCallExpImpl;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OCLValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class OperationCallExpImpl
extends FeatureCallExpImpl
implements OperationCallExp {
    public static final int OPERATION_CALL_EXP_FEATURE_COUNT = 16;
    public static final int OPERATION_CALL_EXP_OPERATION_COUNT = 15;
    protected static final boolean IS_VIRTUAL_EDEFAULT = true;
    protected static final int IS_VIRTUAL_EFLAG = 4096;
    protected EList<OCLExpression> ownedArguments;
    protected Operation referredOperation;

    protected OperationCallExpImpl() {
        this.eFlags |= 0x1000;
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.OPERATION_CALL_EXP;
    }

    @Override
    public boolean isIsVirtual() {
        return (this.eFlags & 0x1000) != 0;
    }

    @Override
    public void setIsVirtual(boolean newIsVirtual) {
        boolean oldIsVirtual;
        boolean bl = oldIsVirtual = (this.eFlags & 0x1000) != 0;
        this.eFlags = newIsVirtual ? (this.eFlags |= 0x1000) : (this.eFlags &= 0xFFFFEFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldIsVirtual, newIsVirtual));
        }
    }

    @Override
    public @NonNull List<OCLExpression> getOwnedArguments() {
        if (this.ownedArguments == null) {
            this.ownedArguments = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 14);
        }
        return this.ownedArguments;
    }

    @Override
    public Operation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (Operation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public Operation basicGetReferredOperation() {
        return this.referredOperation;
    }

    @Override
    public void setReferredOperation(Operation newReferredOperation) {
        Operation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetOwnedSource(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getOwnedArguments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 8: {
                return this.getTypeValue();
            }
            case 9: {
                return this.isIsImplicit();
            }
            case 10: {
                return this.isIsSafe();
            }
            case 11: {
                return this.getOwnedSource();
            }
            case 12: {
                return this.isIsPre();
            }
            case 13: {
                return this.isIsVirtual();
            }
            case 14: {
                return this.getOwnedArguments();
            }
            case 15: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
            case 8: {
                this.setTypeValue((Type)newValue);
                return;
            }
            case 9: {
                this.setIsImplicit((Boolean)newValue);
                return;
            }
            case 10: {
                this.setIsSafe((Boolean)newValue);
                return;
            }
            case 11: {
                this.setOwnedSource((OCLExpression)newValue);
                return;
            }
            case 12: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 13: {
                this.setIsVirtual((Boolean)newValue);
                return;
            }
            case 14: {
                this.getOwnedArguments().clear();
                this.getOwnedArguments().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setReferredOperation((Operation)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
            case 8: {
                this.setTypeValue(null);
                return;
            }
            case 9: {
                this.setIsImplicit(false);
                return;
            }
            case 10: {
                this.setIsSafe(false);
                return;
            }
            case 11: {
                this.setOwnedSource(null);
                return;
            }
            case 12: {
                this.setIsPre(false);
                return;
            }
            case 13: {
                this.setIsVirtual(true);
                return;
            }
            case 14: {
                this.getOwnedArguments().clear();
                return;
            }
            case 15: {
                this.setReferredOperation(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
            case 8: {
                return this.typeValue != null;
            }
            case 9: {
                return (this.eFlags & 0x200) != 0;
            }
            case 10: {
                return (this.eFlags & 0x400) != 0;
            }
            case 11: {
                return this.ownedSource != null;
            }
            case 12: {
                return (this.eFlags & 0x800) != 0;
            }
            case 13: {
                return (this.eFlags & 0x1000) == 0;
            }
            case 14: {
                return this.ownedArguments != null && !this.ownedArguments.isEmpty();
            }
            case 15: {
                return this.referredOperation != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == CallExp.class) {
            switch (baseOperationID) {
                case 6: {
                    return 13;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.isNonNull();
            }
            case 4: {
                return this.isNull();
            }
            case 5: {
                return this.validateTypeIsNotNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 13: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateSafeSourceCannotBeMap((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.getReferredElement();
            }
            case 10: {
                return this.hasOclVoidOverload();
            }
            case 11: {
                return this.validateArgumentCount((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 12: {
                return this.validateArgumentTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 14: {
                return this.validateUnsafeSourceCanNotBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitOperationCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredOperation();
    }

    @Override
    public boolean validateArgumentTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "OperationCallExp::ArgumentTypeIsConformant";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.OPERATION_CALL_EXP___VALIDATE_ARGUMENT_TYPE_IS_CONFORMANT__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                InvalidValueException CAUGHT_forAll;
                try {
                    Boolean forAll;
                    Class safe_owningClass_source;
                    OrderedSetValue safe_ownedParameters_source;
                    @Nullable Operation operation = this.getReferredOperation();
                    @NonNull Boolean ownedParameters = operation == null;
                    if (ownedParameters == Boolean.TRUE) {
                        safe_ownedParameters_source = null;
                    } else {
                        OrderedSetValue BOXED_ownedParameters_0;
                        assert (operation != null);
                        @NonNull List<Parameter> ownedParameters_0 = operation.getOwnedParameters();
                        safe_ownedParameters_source = BOXED_ownedParameters_0 = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, ownedParameters_0);
                    }
                    @NonNull Boolean owningClass = operation == null;
                    if (owningClass == Boolean.TRUE) {
                        safe_owningClass_source = null;
                    } else {
                        Class owningClass_0;
                        assert (operation != null);
                        safe_owningClass_source = owningClass_0 = operation.getOwningClass();
                    }
                    @NonNull List<OCLExpression> ownedArguments = this.getOwnedArguments();
                    @NonNull OrderedSetValue BOXED_ownedArguments = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, ownedArguments);
                    @NonNull IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedArguments);
                    @NonNull IntegerRange RNG = ValueUtil.createRange(PivotTables.INT_1, size);
                    @NonNull SequenceValue Sequence = ValueUtil.createSequenceRange(PivotTables.SEQ_PRIMid_Integer, RNG);
                    @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                    @NonNull Iterator<Object> ITERATOR_i = Sequence.iterator();
                    while (true) {
                        InvalidValueException CAUGHT_safe_conformsTo_source;
                        if (!ITERATOR_i.hasNext()) {
                            if (accumulator == null) {
                                forAll = null;
                                break;
                            }
                            if (accumulator == ValueUtil.TRUE_VALUE) {
                                forAll = ValueUtil.TRUE_VALUE;
                                break;
                            }
                            throw (InvalidValueException)accumulator;
                        }
                        @NonNull IntegerValue i = (IntegerValue)ITERATOR_i.next();
                        try {
                            Boolean safe_conformsTo_source;
                            OCLValue CAUGHT_type;
                            Class requiredType;
                            @Nullable OCLExpression argument = (OCLExpression)OrderedCollectionAtOperation.INSTANCE.evaluate(BOXED_ownedArguments, i);
                            if (safe_ownedParameters_source == null) {
                                throw new InvalidValueException("Null ''Collection'' rather than ''OclVoid'' value required", new Object[0]);
                            }
                            @NonNull OrderedSetValue safe_at_sources = (OrderedSetValue)CollectionExcludingOperation.INSTANCE.evaluate(safe_ownedParameters_source, null);
                            @Nullable Parameter parameter = (Parameter)OrderedCollectionAtOperation.INSTANCE.evaluate(safe_at_sources, i);
                            if (parameter == null) {
                                throw new InvalidValueException("Null source for 'TypedElement::type'", new Object[0]);
                            }
                            @Nullable Type parameterType = parameter.getType();
                            boolean isTypeof = parameter.isIsTypeof();
                            if (isTypeof) {
                                Class TYP_Class;
                                requiredType = TYP_Class = idResolver.getClass(PivotTables.CLSSid_Class, null);
                            } else {
                                Type safe_specializeIn_source;
                                OCLValue CAUGHT_parameterType;
                                try {
                                    CAUGHT_parameterType = parameterType;
                                }
                                catch (Exception e) {
                                    CAUGHT_parameterType = ValueUtil.createInvalidValue(e);
                                }
                                @NonNull Boolean specializeIn = CAUGHT_parameterType == null;
                                if (specializeIn == Boolean.TRUE) {
                                    safe_specializeIn_source = null;
                                } else {
                                    Type specializeIn_0;
                                    assert (parameterType != null);
                                    safe_specializeIn_source = specializeIn_0 = parameterType.specializeIn(this, safe_owningClass_source);
                                }
                                requiredType = safe_specializeIn_source;
                            }
                            if (argument == null) {
                                throw new InvalidValueException("Null source for 'TypedElement::type'", new Object[0]);
                            }
                            @Nullable Type type = argument.getType();
                            try {
                                CAUGHT_type = type;
                            }
                            catch (Exception e) {
                                CAUGHT_type = ValueUtil.createInvalidValue(e);
                            }
                            @NonNull Boolean conformsTo = CAUGHT_type == null;
                            if (conformsTo == Boolean.TRUE) {
                                safe_conformsTo_source = null;
                            } else {
                                if (type == null) {
                                    throw new InvalidValueException("Null ''Type'' rather than ''OclVoid'' value required", new Object[0]);
                                }
                                boolean conformsTo_0 = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)type, (Object)requiredType);
                                safe_conformsTo_source = conformsTo_0;
                            }
                            CAUGHT_safe_conformsTo_source = safe_conformsTo_source;
                        }
                        catch (Exception e) {
                            CAUGHT_safe_conformsTo_source = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_safe_conformsTo_source == ValueUtil.FALSE_VALUE) {
                            forAll = ValueUtil.FALSE_VALUE;
                            break;
                        }
                        if (CAUGHT_safe_conformsTo_source == ValueUtil.TRUE_VALUE) continue;
                        if (CAUGHT_safe_conformsTo_source == null) {
                            if (accumulator != ValueUtil.TRUE_VALUE) continue;
                            accumulator = null;
                            continue;
                        }
                        if (CAUGHT_safe_conformsTo_source instanceof InvalidValueException) {
                            accumulator = CAUGHT_safe_conformsTo_source;
                            continue;
                        }
                        accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                    }
                    CAUGHT_forAll = forAll;
                }
                catch (Exception e) {
                    CAUGHT_forAll = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::ArgumentTypeIsConformant", this, null, diagnostics, context, null, severity_0, CAUGHT_forAll, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("OperationCallExp::ArgumentTypeIsConformant", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "OperationCallExp::SafeSourceCanBeNull";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.OPERATION_CALL_EXP___VALIDATE_SAFE_SOURCE_CAN_BE_NULL__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean isSafe;
                    boolean ne;
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    boolean bl = ne = ownedSource != null;
                    @Nullable Boolean and = !ne ? ValueUtil.FALSE_VALUE : (!(isSafe = this.isIsSafe()) ? ValueUtil.FALSE_VALUE : ValueUtil.TRUE_VALUE);
                    if (and == ValueUtil.FALSE_VALUE) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_not;
                        try {
                            Serializable CAUGHT_isNonNull;
                            try {
                                if (ownedSource == null) {
                                    throw new InvalidValueException("Null source for 'pivot::OCLExpression::isNonNull() : Boolean[1]'", new Object[0]);
                                }
                                boolean isNonNull = ownedSource.isNonNull();
                                CAUGHT_isNonNull = Boolean.valueOf(isNonNull);
                            }
                            catch (Exception e) {
                                CAUGHT_isNonNull = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_isNonNull instanceof InvalidValueException) {
                                throw CAUGHT_isNonNull;
                            }
                            @Nullable Boolean not = CAUGHT_isNonNull == ValueUtil.FALSE_VALUE ? ValueUtil.TRUE_VALUE : (CAUGHT_isNonNull == ValueUtil.TRUE_VALUE ? ValueUtil.FALSE_VALUE : null);
                            CAUGHT_not = not;
                        }
                        catch (Exception e) {
                            CAUGHT_not = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_not == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_not instanceof InvalidValueException) {
                                throw CAUGHT_not;
                            }
                            result = and == null || CAUGHT_not == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("OperationCallExp::SafeSourceCanBeNull", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateUnsafeSourceCanNotBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "OperationCallExp::UnsafeSourceCanNotBeNull";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.OPERATION_CALL_EXP___VALIDATE_UNSAFE_SOURCE_CAN_NOT_BE_NULL__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean hasOclVoidOverload = this.hasOclVoidOverload();
                    @Nullable Boolean not = !hasOclVoidOverload ? ValueUtil.TRUE_VALUE : (hasOclVoidOverload ? ValueUtil.FALSE_VALUE : null);
                    if (not == ValueUtil.FALSE_VALUE) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_implies;
                        try {
                            Boolean implies;
                            Serializable CAUGHT_and;
                            try {
                                Object and;
                                boolean ne;
                                @Nullable OCLExpression ownedSource = this.getOwnedSource();
                                boolean bl = ne = ownedSource != null;
                                if (!ne) {
                                    and = ValueUtil.FALSE_VALUE;
                                } else {
                                    boolean isSafe = this.isIsSafe();
                                    @Nullable Boolean not_0 = !isSafe ? ValueUtil.TRUE_VALUE : (isSafe ? ValueUtil.FALSE_VALUE : null);
                                    and = not_0 == ValueUtil.FALSE_VALUE ? ValueUtil.FALSE_VALUE : (not_0 == null ? null : ValueUtil.TRUE_VALUE);
                                }
                                CAUGHT_and = and;
                            }
                            catch (Exception e) {
                                CAUGHT_and = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_and == ValueUtil.FALSE_VALUE) {
                                implies = ValueUtil.TRUE_VALUE;
                            } else {
                                Serializable CAUGHT_isNonNull;
                                try {
                                    @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                                    if (ownedSource_0 == null) {
                                        throw new InvalidValueException("Null source for 'pivot::OCLExpression::isNonNull() : Boolean[1]'", new Object[0]);
                                    }
                                    boolean isNonNull = ownedSource_0.isNonNull();
                                    CAUGHT_isNonNull = Boolean.valueOf(isNonNull);
                                }
                                catch (Exception e) {
                                    CAUGHT_isNonNull = ValueUtil.createInvalidValue(e);
                                }
                                if (CAUGHT_isNonNull == ValueUtil.TRUE_VALUE) {
                                    implies = ValueUtil.TRUE_VALUE;
                                } else {
                                    if (CAUGHT_and instanceof InvalidValueException) {
                                        throw CAUGHT_and;
                                    }
                                    if (CAUGHT_isNonNull instanceof InvalidValueException) {
                                        throw CAUGHT_isNonNull;
                                    }
                                    implies = CAUGHT_and == null ? null : ValueUtil.FALSE_VALUE;
                                }
                            }
                            CAUGHT_implies = implies;
                        }
                        catch (Exception e) {
                            CAUGHT_implies = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_implies == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_implies instanceof InvalidValueException) {
                                throw CAUGHT_implies;
                            }
                            result = not == null || CAUGHT_implies == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::UnsafeSourceCanNotBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("OperationCallExp::UnsafeSourceCanNotBeNull", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateArgumentCount(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "OperationCallExp::ArgumentCount";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.OPERATION_CALL_EXP___VALIDATE_ARGUMENT_COUNT__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    OrderedSetValue safe_ownedParameters_source;
                    @NonNull List<OCLExpression> ownedArguments = this.getOwnedArguments();
                    @NonNull OrderedSetValue BOXED_ownedArguments = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, ownedArguments);
                    @NonNull IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedArguments);
                    @Nullable Operation referredOperation = this.getReferredOperation();
                    @NonNull Boolean ownedParameters = referredOperation == null;
                    if (ownedParameters == Boolean.TRUE) {
                        safe_ownedParameters_source = null;
                    } else {
                        OrderedSetValue BOXED_ownedParameters_0;
                        assert (referredOperation != null);
                        @NonNull List<Parameter> ownedParameters_0 = referredOperation.getOwnedParameters();
                        safe_ownedParameters_source = BOXED_ownedParameters_0 = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, ownedParameters_0);
                    }
                    if (safe_ownedParameters_source == null) {
                        throw new InvalidValueException("Null ''Collection'' rather than ''OclVoid'' value required", new Object[0]);
                    }
                    @NonNull OrderedSetValue safe_size_sources = (OrderedSetValue)CollectionExcludingOperation.INSTANCE.evaluate(safe_ownedParameters_source, null);
                    @NonNull IntegerValue size_0 = CollectionSizeOperation.INSTANCE.evaluate(safe_size_sources);
                    boolean result = size.equals(size_0);
                    CAUGHT_result = Boolean.valueOf(result);
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::ArgumentCount", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("OperationCallExp::ArgumentCount", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean hasOclVoidOverload() {
        @NonNull Executor executor = PivotUtil.getExecutor(this, null);
        Operation referredOperation = this.getReferredOperation();
        OperationId baseOperationId = referredOperation.getOperationId();
        Class oclVoidType = executor.getStandardLibrary().getOclVoidType();
        CompleteClass oclVoidCompleteClass = executor.getEnvironmentFactory().getCompleteModel().getCompleteClass(oclVoidType);
        Operation oclVoidOperation = oclVoidCompleteClass.getOperation(baseOperationId);
        return oclVoidOperation != null;
    }
}

