/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.helper.tests;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.helper.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;

public class ParsingTest
extends AbstractTestSuite {
    public void test_createQuery_125684() {
        OCLExpression expr;
        this.helper.setContext((Object)this.fruit);
        try {
            expr = this.helper.createQuery("color <> Color::black");
            ParsingTest.assertNotNull((Object)expr);
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        try {
            expr = this.helper.createQuery("color");
            ParsingTest.assertNotNull((Object)expr);
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_createInvariant() {
        this.helper.setContext((Object)this.fruit);
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("color <> Color::black");
            ParsingTest.assertNotNull((Object)constraint);
            ParsingTest.assertNotNull((Object)constraint.getSpecification().getBodyExpression());
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_createInvariant_nonBoolean_125684() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("color");
            ParsingTest.fail((String)"Parse should not have succeeded");
        }
        catch (Exception e) {
            ParsingTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_createPrecondition() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            Constraint constraint = (Constraint)this.helper.createPrecondition("color <> Color::black");
            ParsingTest.assertNotNull((Object)constraint);
            ParsingTest.assertNotNull((Object)constraint.getSpecification().getBodyExpression());
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_createPostcondition() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            Constraint constraint = (Constraint)this.helper.createPostcondition("color <> self.color@pre implies self.color = color ");
            ParsingTest.assertNotNull((Object)constraint);
            ParsingTest.assertNotNull((Object)constraint.getSpecification().getBodyExpression());
            constraint = (Constraint)this.helper.createPostcondition("self->asSequence@pre()->notEmpty()");
            ParsingTest.assertTrue((boolean)((OperationCallExp)((OperationCallExp)constraint.getSpecification().getBodyExpression()).getSource()).isMarkedPre());
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_createBodyCondition() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_preferredColor);
        try {
            Constraint constraint = (Constraint)this.helper.createBodyCondition("result = (if true then Color::red else Color::brown endif)");
            ParsingTest.assertNotNull((Object)constraint);
            ParsingTest.assertNotNull((Object)constraint.getSpecification().getBodyExpression());
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_dataTypeAsContext() {
        this.helper.setContext((Object)ecore.getEString());
        try {
            String constraint = "self.toUpper() <> self.toLower()";
            ParsingTest.assertTrue((boolean)this.check(this.helper, "anything", "self.toUpper() <> self.toLower()"));
            ParsingTest.assertTrue((boolean)this.check(this.helper, "ANYTHING", "self.toUpper() <> self.toLower()"));
            ParsingTest.assertEquals((Object)"ANYTHING", (Object)this.evaluate(this.helper, "anything", "self.toUpper()"));
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_dataTypeAsContext_inferred() {
        EcoreEnvironment env = (EcoreEnvironment)EcoreEnvironmentFactory.INSTANCE.createInstanceContext(this.ocl.getEnvironment(), (Object)"anything");
        this.helper.setContext((Object)((EClassifier)env.getContextClassifier()));
        try {
            String constraint = "self.toUpper() <> self.toLower()";
            ParsingTest.assertTrue((boolean)this.check(this.helper, "anything", "self.toUpper() <> self.toLower()"));
            ParsingTest.assertTrue((boolean)this.check(this.helper, "ANYTHING", "self.toUpper() <> self.toLower()"));
            ParsingTest.assertEquals((Object)"ANYTHING", (Object)this.evaluate(this.helper, "anything", "self.toUpper()"));
        }
        catch (Exception e) {
            ParsingTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }
}

