/*
 * Decompiled with CFR 0.152.
 */
package behavioral.events.util;

import behavioral.events.EventFilter;
import behavioral.events.EventProducer;
import behavioral.events.EventsPackage;
import behavioral.events.Subscription;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsValidator
extends EObjectValidator {
    public static final EventsValidator INSTANCE = new EventsValidator();
    public static final String DIAGNOSTIC_SOURCE = "behavioral.events";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String SUBSCRIPTION__SUBSCRIBING_CLASS_MATCH_PRODUCER__EEXPRESSION = "self.producer.notificationSignatures->forAll(ms:data::classes::MethodSignature |\r\n    self.subscribingClass.allSignatures()->exists(s:data::classes::MethodSignature|s.conformsTo(ms)))";
    protected static final String EVENT_FILTER__FILTER_BLOCK_SIGNATURE_MATCH_NOTIFICATION_SIGNATURE__EEXPRESSION = "self.subscription.producer.notificationSignatures->exists(ms:data::classes::MethodSignature |\r\n    ms.conformsTo(self.test.getImplementedSignature()))";

    protected EPackage getEPackage() {
        return EventsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSubscription((Subscription)value, diagnostics, context);
            }
            case 1: {
                return this.validateEventProducer((EventProducer)value, diagnostics, context);
            }
            case 2: {
                return this.validateEventFilter((EventFilter)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSubscription(Subscription subscription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(subscription, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(subscription, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(subscription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSubscription_SubscribingClassMatchProducer(subscription, diagnostics, context);
        }
        return result;
    }

    public boolean validateSubscription_SubscribingClassMatchProducer(Subscription subscription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EventsPackage.Literals.SUBSCRIPTION, subscription, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SubscribingClassMatchProducer", SUBSCRIPTION__SUBSCRIBING_CLASS_MATCH_PRODUCER__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEventProducer(EventProducer eventProducer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(eventProducer, diagnostics, context);
    }

    public boolean validateEventFilter(EventFilter eventFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventFilter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventFilter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEventFilter_FilterBlockSignatureMatchNotificationSignature(eventFilter, diagnostics, context);
        }
        return result;
    }

    public boolean validateEventFilter_FilterBlockSignatureMatchNotificationSignature(EventFilter eventFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(EventsPackage.Literals.EVENT_FILTER, eventFilter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FilterBlockSignatureMatchNotificationSignature", EVENT_FILTER__FILTER_BLOCK_SIGNATURE_MATCH_NOTIFICATION_SIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

