/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.validity.test.AbstractValidityTestCase;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.junit.After;
import org.junit.Before;

public class AbstractExportOCLValidationResultTests
extends AbstractValidityTestCase {
    protected IValidityExporter exporter;
    protected EList<Result> results;

    protected @NonNull URL getTestResource(@NonNull String resourceName) {
        URL projectURL;
        block5: {
            projectURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
            try {
                if (projectURL == null || !Platform.isRunning()) break block5;
                try {
                    projectURL = FileLocator.resolve((URL)projectURL);
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                    assert (false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (URL)ClassUtil.nonNullState((Object)projectURL);
    }

    protected @NonNull String getProjectFileName(String referenceName) throws IOException {
        String projectName = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        URL projectURL = this.getTestResource(projectName);
        AbstractExportOCLValidationResultTests.assertNotNull((Object)projectURL);
        String projectFileName = String.valueOf(projectURL.getFile().replace("\\", "/")) + "/" + referenceName;
        int jarIndex = projectFileName.indexOf(".jar!/");
        if (jarIndex > 0) {
            File projectFile = File.createTempFile("ocltest", referenceName);
            projectFile.deleteOnExit();
            projectFileName = projectFile.toString();
        }
        return projectFileName;
    }

    protected void initExporter(@NonNull String exporterType) {
        this.exporter = ValidityExporterRegistry.INSTANCE.getExporter(exporterType);
        AbstractExportOCLValidationResultTests.assertNotNull((Object)this.exporter);
        TEST_PROGRESS.println("exporter = " + this.exporter);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initTestModels();
        this.initValidityManager(EMFPlugin.IS_ECLIPSE_RUNNING ? null : new ValidityManager());
        this.results = this.resultSet.getResults();
        TEST_PROGRESS.println("results = " + this.results);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.exporter = null;
        TEST_PROGRESS.println("-exporter");
        super.tearDown();
    }
}

