/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserElementFormatter;
import org.eclipse.ocl.examples.xtext.serializer.UserElementSerializer;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;

public class UserModelAnalysis {
    @Inject
    private @NonNull IValueConverterService valueConverterService;
    @Inject
    private @NonNull ICrossReferenceSerializer crossReferenceSerializer;
    @Inject
    private @NonNull SerializationMetaData.Provider serializationMetaDataProvider;
    private @Nullable SerializationMetaData serializationMetaData;
    private final @NonNull Map<@NonNull EObject, @NonNull UserElementAnalysis> element2elementAnalysis = new HashMap<EObject, UserElementAnalysis>();
    private int debugUserElementAnalysisCount = 0;
    private int debugSerializeCount = 0;
    private int debugDynamicRuleMatchCount = 0;

    public void analyze(@NonNull EObject model) {
        assert (model.eContainer() == null);
        UserElementAnalysis rootElementAnalysis = new UserElementAnalysis(this, null, model);
        this.analyzeHierarchy(rootElementAnalysis, model);
        rootElementAnalysis.getSerializationRules();
    }

    private void analyzeHierarchy(@NonNull UserElementAnalysis parentAnalysis, @NonNull EObject eParent) {
        this.element2elementAnalysis.put(eParent, parentAnalysis);
        for (EObject eChild : eParent.eContents()) {
            EReference eContainmentFeature = eChild.eContainmentFeature();
            assert (eContainmentFeature.isContainment() && !eContainmentFeature.isDerived() && !eContainmentFeature.isTransient() && !eContainmentFeature.isVolatile());
            UserElementAnalysis childAnalysis = new UserElementAnalysis(this, parentAnalysis, eChild);
            this.analyzeHierarchy(childAnalysis, eChild);
        }
    }

    public @NonNull UserElementFormatter createUserElementFormatter(@NonNull INode node, @NonNull AbstractElement compoundedGrammarElement, @NonNull EObject eObject) {
        return new UserElementFormatter(node, compoundedGrammarElement, this, eObject);
    }

    public @NonNull UserElementSerializer createUserElementSerializer(@NonNull DynamicRuleMatch dynamicRuleMatch, @NonNull EObject eObject) {
        return new UserElementSerializer(dynamicRuleMatch, eObject);
    }

    public void debugAddDynamicRuleMatch(@NonNull DynamicRuleMatch dynamicRuleMatch) {
        ++this.debugDynamicRuleMatchCount;
    }

    public void debugAddUserElementAnalysis(@NonNull UserElementAnalysis userElementAnalysis) {
        ++this.debugUserElementAnalysisCount;
    }

    public @NonNull String diagnose() {
        StringBuilder s = new StringBuilder();
        s.append("debugUserElementAnalysisCount = " + this.debugUserElementAnalysisCount + "\n");
        s.append("debugSerializeCount = " + this.debugSerializeCount + "\n");
        s.append("debugDynamicRuleMatchCount = " + this.debugDynamicRuleMatchCount + "\n");
        @NonNull String castString = s.toString();
        return castString;
    }

    private boolean diagnose(@NonNull DiagnosticStringBuilder s, @NonNull EObject eObject, int depth) {
        boolean childDiagnosed = false;
        for (EObject eChild : eObject.eContents()) {
            assert (eChild != null);
            if (!this.diagnose(s, eChild, depth + 1)) continue;
            childDiagnosed = true;
        }
        if (childDiagnosed) {
            return true;
        }
        UserElementAnalysis elementAnalysis = this.getElementAnalysis(eObject);
        return elementAnalysis.diagnose(s);
    }

    public @NonNull ICrossReferenceSerializer getCrossReferenceSerializer() {
        return this.crossReferenceSerializer;
    }

    public @NonNull UserElementAnalysis getElementAnalysis(@NonNull EObject element) {
        return SerializationUtils.nonNullState(this.element2elementAnalysis.get(element));
    }

    public @NonNull SerializationMetaData getSerializationMetaData() {
        SerializationMetaData serializationMetaData2 = this.serializationMetaData;
        if (serializationMetaData2 == null) {
            this.serializationMetaData = serializationMetaData2 = this.serializationMetaDataProvider.get();
        }
        return serializationMetaData2;
    }

    public @NonNull IValueConverterService getValueConverterService() {
        return this.valueConverterService;
    }

    public void serialize(@NonNull SerializationBuilder serializationBuilder, @NonNull EObject eObject, @Nullable GrammarRuleValue targetRuleValue) {
        ++this.debugSerializeCount;
        if ("MappingCallCS".equals(eObject.eClass().getName())) {
            this.getClass();
        }
        UserElementAnalysis elementAnalysis = this.getElementAnalysis(eObject);
        String tos = elementAnalysis.toString();
        DynamicRuleMatch okMatch = elementAnalysis.basicCreateDynamicRuleMatch(targetRuleValue != null ? (ParserRuleValue)targetRuleValue : null);
        if (okMatch != null) {
            UserElementSerializer serializer = this.createUserElementSerializer(okMatch, eObject);
            serializer.serialize(serializationBuilder);
        } else {
            DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(this.getSerializationMetaData());
            boolean hasContext = this.diagnose(s, eObject, 0);
            s.append("\n\n\u00abincompatible");
            if (!hasContext) {
                elementAnalysis.diagnoseEObject(s, eObject);
                s.append("\n");
            } else {
                s.append("'");
                s.appendObject(eObject.eClass().getName());
                s.append("'\n");
            }
            if (!elementAnalysis.diagnose(s) && targetRuleValue != null) {
                s.append(" - ");
                s.appendObject(targetRuleValue);
                s.append(" required.");
            }
            s.append("\u00bb\n\n");
            @NonNull String castString = s.toString();
            serializationBuilder.appendError(castString);
        }
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(this.getSerializationMetaData());
        s.append("User object <=> Xtext containing assignment(s) : Xtext production rule\n");
        ArrayList<@NonNull UserElementAnalysis> elementAnalyses = new ArrayList<UserElementAnalysis>(this.element2elementAnalysis.values());
        Collections.sort(elementAnalyses, SerializationUtils.NAMEABLE_COMPARATOR);
        boolean isFirst = true;
        for (UserElementAnalysis elementAnalysis : elementAnalyses) {
            if (!isFirst) {
                s.append("\n");
            }
            s.append("  ");
            elementAnalysis.toString(s, 1);
            isFirst = false;
        }
        return s.toString();
    }
}

