/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLocalValue;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;

public class VMLocalVariable
extends VMVariable {
    private final long myFrameID;
    private final @NonNull VMEvaluationEnvironment evaluationEnvironment;

    VMLocalVariable(IVMDebugTarget debugTarget, VMVariableData vmVar, long frameID, @NonNull VMEvaluationEnvironment evaluationEnvironment) {
        super(debugTarget, vmVar, frameID);
        this.myFrameID = frameID;
        this.evaluationEnvironment = evaluationEnvironment;
    }

    @Override
    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            VMLocalValue.LocalValue lv = new VMLocalValue.LocalValue();
            lv.valueObject = this.vmVar.valueObject;
            lv.valueType = null;
            this.fValue = new VMLocalValue(this.getOCLDebugTarget(), this.myFrameID, VariableFinder.getVariablePath(VariableFinder.parseURI(this.vmVar.variableURI)), lv, this.evaluationEnvironment);
        }
        return this.fValue;
    }
}

