/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractSerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CompoundElement;

public abstract class AbstractSerializationNode
extends AbstractSerializationElement
implements SerializationNode {
    protected final @NonNull GrammarCardinality grammarCardinality;

    protected AbstractSerializationNode(@NonNull GrammarCardinality grammarCardinality) {
        this.grammarCardinality = grammarCardinality;
    }

    @Override
    public @NonNull SerializationElement addConcatenation(@NonNull SerializationElement additionalSerializationElement) {
        if (additionalSerializationElement.isNull()) {
            return this;
        }
        if (additionalSerializationElement.isNode()) {
            ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>();
            newList.add(this);
            newList.add(additionalSerializationElement.asNode());
            return new ListOfSerializationNode(newList);
        }
        if (additionalSerializationElement.isList()) {
            throw new IllegalStateException();
        }
        if (additionalSerializationElement.isListOfList()) {
            for (List<SerializationNode> additionalList : additionalSerializationElement.asListOfList().getLists()) {
                additionalList.add(0, this);
            }
            return additionalSerializationElement;
        }
        throw new UnsupportedOperationException();
    }

    protected void appendCardinality(@NonNull DiagnosticStringBuilder s, int depth) {
        if (depth >= 0 || !this.grammarCardinality.isOne()) {
            s.append("[");
            s.appendObject((Object)this.grammarCardinality);
            s.append("]");
        }
    }

    @Override
    public @NonNull SerializationNode asNode() {
        return this;
    }

    @Override
    public @NonNull SerializationNode freezeAlternatives(@NonNull Alternatives alternatives) {
        return this;
    }

    @Override
    public @NonNull SerializationElement freezeSequences(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, boolean isRootAlternative) {
        @NonNull List<@NonNull SerializationNode> castSingletonList = Collections.singletonList(this);
        return AbstractSerializationNode.createFrozenSequence(compoundElement, grammarCardinality, castSingletonList, isRootAlternative);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull SerializationSegment @Nullable [] gatherStepsAndSubIdiomsAll(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull List<@NonNull SerializationStep> stepsList, @NonNull Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms) {
        int cardinalityVariableIndex;
        SerializationSegment[] allSerializationSegments = null;
        SerializationSegment[] eachSerializationSegments = null;
        @NonNull List subIdioms = (List)SerializationUtils.maybeNull(serializationNode2subIdioms.get(this));
        if (subIdioms != null) {
            GrammarAnalysis grammarAnalysis = serializationRuleAnalysis.getGrammarAnalysis();
            allSerializationSegments = grammarAnalysis.getSerializationSegments(subIdioms, true);
            eachSerializationSegments = grammarAnalysis.getSerializationSegments(subIdioms, false);
        }
        if ((cardinalityVariableIndex = serializationRuleAnalysis.getCardinalityVariableIndex(this)) >= 0 || allSerializationSegments != null) {
            stepsList.add((SerializationStep)new SerializationStep.SerializationStepSequence(cardinalityVariableIndex, 1, this.grammarCardinality, allSerializationSegments));
        }
        return eachSerializationSegments;
    }

    @Override
    public @NonNull GrammarCardinality getGrammarCardinality() {
        return this.grammarCardinality;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isOne() {
        return this.grammarCardinality.isOne();
    }

    @Override
    public boolean isRedundant() {
        return false;
    }

    @Override
    public @NonNull SerializationNode setGrammarCardinality(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality) {
        if (this.grammarCardinality.isZeroOrMore()) {
            return this;
        }
        return this.clone(grammarCardinality);
    }
}

