/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.validity.test.AbstractExportOCLValidationResultTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.InputSource;

public class HTMLExportOCLValidationResultTests
extends AbstractExportOCLValidationResultTests {
    private static final String WARNING_NUMBER_XPATH_LOCATION = "//table[2]/tr[4]/td[2]";
    private static final String INFO_NUMBER_XPATH_LOCATION = "//table[2]/tr[3]/td[2]";
    private static final String ERROR_NUMBER_XPATH_LOCATION = "//table[2]/tr[5]/td[2]";
    private static final String FAILURE_NUMBER_XPATH_LOCATION = "//table[2]/tr[6]/td[2]";
    private static final String SUCCESS_NUMBER_XPATH_LOCATION = "//table[2]/tr[2]/td[2]";
    private String exportedFileName = null;
    private XPath xPathEngine = null;

    protected void assertXPathTrue(@NonNull String contents, String expression) throws XPathExpressionException, CoreException, IOException {
        InputSource stream = new InputSource(new StringReader(contents));
        this.xPathEngine.compile(expression);
        Object xPathResult = this.xPathEngine.evaluate(expression, stream, XPathConstants.BOOLEAN);
        HTMLExportOCLValidationResultTests.assertTrue((String)("Expected \"" + expression + "\" to be true"), (boolean)((Boolean)xPathResult));
    }

    protected @NonNull String doTest() throws IOException {
        String exported = this.exporter.export(this.rootNode, this.exportedFileName);
        FileWriter writer = new FileWriter(this.exportedFileName);
        writer.append(exported);
        writer.close();
        TEST_PROGRESS.println("exported " + this.ecoreResource.getURI());
        return exported;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.exportedFileName = this.getProjectFileName(String.valueOf(this.getTestName()) + ".html");
        this.initExporter("html");
        XPathFactory factory = XPathFactory.newInstance();
        this.xPathEngine = factory.newXPath();
        TEST_PROGRESS.println("xPathEngine = " + this.xPathEngine);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testHTMLExport_LoggingMetricsWithNoSeverity() throws XPathExpressionException, CoreException, IOException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=0");
    }

    @Test
    public void testHTMLExport_LoggingMetricsWithInformationSeverity() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=0");
    }

    @Test
    public void testHTMLExport_LoggingMetricsWithWarningSeverity() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=0");
    }

    @Test
    public void testHTMLExport_LoggingMetricsWithErrorSeverity() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute2").setSeverity(Severity.ERROR);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=0");
    }

    @Test
    public void testHTMLExport_LoggingMetricsWithFailureSeverity() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute2").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute4").setSeverity(Severity.FATAL);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=1");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=1");
    }

    @Test
    public void testHTMLExport_LogNullDiagnosticMessage() throws XPathExpressionException, CoreException, IOException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[3]/tr[2]/td[5]='null diagnostic message'");
    }

    @Test
    public void testHTMLExport_LogInfoDiagnosticMessage() throws XPathExpressionException, CoreException, IOException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String diagnostic = "Diag INFO";
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setDiagnostic((Object)diagnostic);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[3]/tr[2]/td[5]='" + diagnostic + "'");
    }

    @Test
    public void testHTMLExport_ProducesOneLogHeading() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EClass::eclass_constraint", "ecoreTest::EClass3").setSeverity(Severity.FATAL);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//body/h2[2]='4.1. Failures'");
    }

    @Test
    public void testHTMLExport_ProducesAllLogHeadings() throws IOException, XPathExpressionException, CoreException {
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EClass::eclass_constraint", "ecoreTest::EClass3").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", "Eclass1 in validityModelTest.ecoretest").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.WARNING);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint", "Eclass1::EClass2").setSeverity(Severity.INFO);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//body/h2[2]='4.1. Infos'");
        this.assertXPathTrue(exported, "//body/h2[3]='4.2. Warnings'");
        this.assertXPathTrue(exported, "//body/h2[4]='4.3. Errors'");
        this.assertXPathTrue(exported, "//body/h2[5]='4.4. Failures'");
    }

    @Test
    public void testHTMLExport_LogContent() throws IOException, XPathExpressionException, CoreException {
        for (Result result : this.results) {
            result.setSeverity(Severity.OK);
        }
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", "Eclass1 in validityModelTest.ecoretest").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint_2", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EClass::eclass_constraint", "ecoreTest::EClass3").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.WARNING);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint", "Eclass1::EClass2").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        String exported = this.doTest();
        String expression = "count(//table[3]/tr[td[1]=' Resource: ecoreTest.ocl'  and td[2]='eclass2_constraint' and contains(td[3],'eclass2_constraint') and td[4]='INFO'])=1";
        this.assertXPathTrue(exported, expression);
        expression = "count(//table[3]/tr[td[1]=' Resource: ecore.ocl'  and td[2]='eattribute_constraint' and contains(td[3],'eattribute_constraint') and td[4]='INFO'])";
        this.assertXPathTrue(exported, expression);
        this.assertXPathTrue(exported, "count(//table[3]/tr)=3");
        expression = "//table[3]/tr[3]/td[1]=' Resource: ecore.ocl'  and //table[3]/tr[3]/td[2]='eattribute_constraint' and contains(//table[3]/tr[3]/td[3],'eattribute_constraint') and //table[3]/tr[3]/td[4]='INFO'";
        this.assertXPathTrue(exported, expression);
        this.assertXPathTrue(exported, "count(//table[3]/tr)=3");
        expression = "count(//table[5]/tr[td[1]=' Resource: ecoreTest.ocl' and td[2]='eclass1_constraint' and contains(td[3],'eclass1_constraint') and td[4]='ERROR'])=1";
        this.assertXPathTrue(exported, expression);
        expression = "count(//table[5]/tr[td[1]=' Resource: ecore.ocl' and td[2]='epackage_constraint_2' and contains(td[3],'epackage_constraint_2') and td[4]='ERROR'])=1";
        this.assertXPathTrue(exported, expression);
        this.assertXPathTrue(exported, "count(//table[5]/tr)=3");
        expression = "count(//table[6]/tr[td[1]=' Resource: ecore.ocl' and td[2]='epackage_constraint' and contains(td[3],'epackage_constraint') and td[4]='FATAL'])=1";
        this.assertXPathTrue(exported, expression);
        expression = "count(//table[6]/tr[td[1]=' Resource: ecore.ocl' and td[2]='eclass_constraint' and contains(td[3],'eclass_constraint') and td[4]='FATAL'])=1";
        this.assertXPathTrue(exported, expression);
        this.assertXPathTrue(exported, "count(//table[6]/tr)=3");
    }

    @Test
    public void testHTMLExport_Statistics() throws IOException, XPathExpressionException, CoreException {
        for (Result result : this.results) {
            result.setSeverity(Severity.OK);
        }
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", "Eclass1 in validityModelTest.ecoretest").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint_2", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.ERROR);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EClass::eclass_constraint", "ecoreTest::EClass3").setSeverity(Severity.FATAL);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint", "Eclass1::EClass2").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.INFO);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        HTMLExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.WARNING);
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[1]/tr/td[2]='" + this.exportedFileName + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[1]='" + TEST_PROJECT_LOCATION + "/" + "model/ecoreTest.ecore" + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[2]='" + TEST_PROJECT_LOCATION + "/" + "model/ecoreTest2.ecore" + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[3]='" + TEST_PROJECT_LOCATION + "/" + "model/validityModelTest.ecoretest" + "'");
        this.assertXPathTrue(exported, "//table[1]/tr[2]/td[2]!=''");
        this.assertXPathTrue(exported, "//body/table[2]/tr/td[2]=" + EXPECTED_RESULTS);
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=" + EXPECTED_SUCCESSES);
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=" + EXPECTED_INFOS);
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=" + EXPECTED_WARNINGS);
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=" + EXPECTED_ERRORS);
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=" + EXPECTED_FAILURES);
    }

    @Test
    public void testHTMLExport_ModelsValidatedSuccessfully() throws IOException, XPathExpressionException, CoreException {
        String exported = this.doTest();
        this.assertXPathTrue(exported, "//table[1]/tr/td[2]='" + this.exportedFileName + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[1]='" + TEST_PROJECT_LOCATION + "/" + "model/ecoreTest.ecore" + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[2]='" + TEST_PROJECT_LOCATION + "/" + "model/ecoreTest2.ecore" + "'");
        this.assertXPathTrue(exported, "//ul[1]/li[3]='" + TEST_PROJECT_LOCATION + "/" + "model/validityModelTest.ecoretest" + "'");
        this.assertXPathTrue(exported, "//table[1]/tr[2]/td[2]!=''");
        this.assertXPathTrue(exported, "//body/table[2]/tr/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[2]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[3]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[4]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[5]/td[2]=0");
        this.assertXPathTrue(exported, "//table[2]/tr[6]/td[2]=0");
        this.assertXPathTrue(exported, "//p[1]='No log to display: models has been successfully validated.'");
    }
}

