/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.manager.PivotExecutorManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class ThreadLocalExecutor {
    public static final @NonNull TracingOption THREAD_LOCAL_ENVIRONMENT_FACTORY = new TracingOption("org.eclipse.ocl.pivot", "environmentFactory/threadLocal");
    private static final @NonNull ThreadLocal<@Nullable ThreadLocalExecutor> INSTANCE = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(ThreadLocalExecutor.class);
    private boolean concurrentEnvironmentFactories = false;
    private @Nullable EnvironmentFactoryInternal environmentFactory = null;
    private @Nullable Executor executor = null;

    public static void attachEnvironmentFactory(@NonNull EnvironmentFactoryInternal environmentFactory) {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            threadLocalExecutor = new ThreadLocalExecutor();
            INSTANCE.set(threadLocalExecutor);
        }
        threadLocalExecutor.localAttachEnvironmentFactory(environmentFactory);
    }

    public static @Nullable EnvironmentFactoryInternal basicGetEnvironmentFactory() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            threadLocalExecutor = new ThreadLocalExecutor();
            INSTANCE.set(threadLocalExecutor);
        }
        return threadLocalExecutor.localBasicGetEnvironmentFactory();
    }

    public static @Nullable Executor basicGetExecutor() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            threadLocalExecutor = new ThreadLocalExecutor();
            INSTANCE.set(threadLocalExecutor);
        }
        return threadLocalExecutor.localBasicGetExecutor();
    }

    public static void detachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localDetachEnvironmentFactory(environmentFactory);
        }
    }

    public static void reset() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localReset();
        }
    }

    public static void resetEnvironmentFactory() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor != null) {
            threadLocalExecutor.localResetEnvironmentFactory();
        }
    }

    public static void setExecutor(@NonNull Executor executor) {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        if (threadLocalExecutor == null) {
            threadLocalExecutor = new ThreadLocalExecutor();
            INSTANCE.set(threadLocalExecutor);
        }
        threadLocalExecutor.localSetExecutor(executor);
    }

    public static @NonNull String toDebugString() {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        return threadLocalExecutor != null ? threadLocalExecutor.toString() : "*** FINALIZED ***";
    }

    public static boolean waitForGC() throws InterruptedException {
        ThreadLocalExecutor threadLocalExecutor = INSTANCE.get();
        return threadLocalExecutor != null && threadLocalExecutor.localWaitForGC();
    }

    private ThreadLocalExecutor() {
    }

    protected void finalize() throws Throwable {
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] Finalize " + this.toString());
        }
        this.localReset();
    }

    private void localAttachEnvironmentFactory(@NonNull EnvironmentFactoryInternal newEnvironmentFactory) {
        if (!this.concurrentEnvironmentFactories && !newEnvironmentFactory.isDisposed()) {
            EnvironmentFactoryInternal oldEnvironmentFactory = this.environmentFactory;
            if (oldEnvironmentFactory == null) {
                this.setEnvironmentFactory(newEnvironmentFactory);
            } else if (oldEnvironmentFactory.isDisposed()) {
                this.setEnvironmentFactory(newEnvironmentFactory);
            } else if (oldEnvironmentFactory != newEnvironmentFactory) {
                this.setEnvironmentFactory(null);
                this.executor = null;
                this.concurrentEnvironmentFactories = true;
                String message = "Concurrent EnvironmentFactory instances inhibit local thread Executor passing.\n\tSee https://wiki.eclipse.org/OCL/FAQ#Concurrent_EnvironmentFactory_instances";
                logger.warn((Object)message);
            }
        } else assert (this.executor == null);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] " + this.toString());
        }
    }

    private @Nullable EnvironmentFactoryInternal localBasicGetEnvironmentFactory() {
        if (this.concurrentEnvironmentFactories) assert (this.environmentFactory == null);
        return this.environmentFactory != null && !this.environmentFactory.isDisposed() ? this.environmentFactory : null;
    }

    private @Nullable Executor localBasicGetExecutor() {
        if (this.concurrentEnvironmentFactories) assert (this.executor == null);
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        return environmentFactory2 == null || !environmentFactory2.isDisposed() ? this.executor : null;
    }

    private void localDetachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        if (this.environmentFactory == environmentFactory) {
            this.localResetEnvironmentFactory();
        }
    }

    private void localReset() {
        this.setEnvironmentFactory(null);
        this.executor = null;
        this.concurrentEnvironmentFactories = false;
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] " + this.toString());
        }
    }

    private void localResetEnvironmentFactory() {
        if (!this.concurrentEnvironmentFactories) {
            this.setEnvironmentFactory(null);
        }
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] " + this.toString());
        }
    }

    private void localSetExecutor(@NonNull Executor executor) {
        if (!this.concurrentEnvironmentFactories) {
            this.executor = executor;
        }
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println("[" + Thread.currentThread().getName() + "] " + this.toString());
        }
        if (executor instanceof PivotExecutorManager) {
            this.localAttachEnvironmentFactory((EnvironmentFactoryInternal)((PivotExecutorManager)executor).getEnvironmentFactory());
        }
    }

    private void setEnvironmentFactory(@Nullable EnvironmentFactoryInternal newEnvironmentFactory) {
        EnvironmentFactoryInternal oldEnvironmentFactory = this.environmentFactory;
        if (newEnvironmentFactory != oldEnvironmentFactory) {
            if (oldEnvironmentFactory != null && !oldEnvironmentFactory.isDisposed()) {
                oldEnvironmentFactory.detach(this);
                this.environmentFactory = null;
            }
            if (newEnvironmentFactory != null && !newEnvironmentFactory.isDisposed()) {
                this.environmentFactory = newEnvironmentFactory;
                newEnvironmentFactory.attach(this);
            }
            this.executor = null;
        }
    }

    public @NonNull String toString() {
        if (!this.concurrentEnvironmentFactories) {
            return String.valueOf(this.environmentFactory != null ? NameUtil.debugSimpleName(this.environmentFactory) : "no-environmentFactory") + " " + (this.executor != null ? NameUtil.debugSimpleName(this.executor) : "no-executor");
        }
        return "**** CONCURRENT ENVIRONMENT FACTORIES ****";
    }

    public boolean localWaitForGC() throws InterruptedException {
        if (this.concurrentEnvironmentFactories) {
            return false;
        }
        EnvironmentFactoryInternal environmentFactory2 = this.environmentFactory;
        if (environmentFactory2 == null) {
            return true;
        }
        int i = 0;
        while (i < 10) {
            environmentFactory2.detachRedundantThreadLocal();
            System.gc();
            System.runFinalization();
            if (environmentFactory2.isDisposed()) {
                return true;
            }
            Thread.sleep(10L);
            ++i;
        }
        return false;
    }
}

