/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.modisco.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.FacetSetShortcutActionUtils;

public class ShortcutFacetSetAction
extends Action {
    private final String actionId;
    private final IFacetManager facetManager;

    public ShortcutFacetSetAction(String actionId, String label, ImageDescriptor imageDescriptor, IFacetManager facetManager) {
        super(label, 2);
        this.actionId = actionId;
        this.facetManager = facetManager;
        FacetSetShortcutActionUtils.setImageDescriptor(this, imageDescriptor);
    }

    public void run() {
        FacetSetShortcutActionUtils.runAction(this, this.actionId, this.getAvailableFacetSets(), this.getAppliedFacetSets());
    }

    private Set<FacetSet> getAvailableFacetSets() {
        ResourceSet resourceSet = this.facetManager.getResourceSet();
        IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet);
        HashSet<FacetSet> availableFS = new HashSet<FacetSet>();
        availableFS.addAll(catalog.getRegisteredFacetSets());
        return availableFS;
    }

    private List<FacetSet> getAppliedFacetSets() {
        return this.facetManager.getManagedFacetSets();
    }
}

