/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class DragForce
extends AbstractForce {
    private static String[] pnames = new String[]{"DragCoefficient"};
    public static final float DEFAULT_DRAG_COEFF = 0.01f;
    public static final float DEFAULT_MIN_DRAG_COEFF = 0.0f;
    public static final float DEFAULT_MAX_DRAG_COEFF = 0.1f;
    public static final int DRAG_COEFF = 0;

    public DragForce(float dragCoeff) {
        this.params = new float[]{dragCoeff};
        this.minValues = new float[]{0.0f};
        this.maxValues = new float[]{0.1f};
    }

    public DragForce() {
        this(0.01f);
    }

    public boolean isItemForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(ForceItem item) {
        item.force[0] = item.force[0] - this.params[0] * item.velocity[0];
        item.force[1] = item.force[1] - this.params[0] * item.velocity[1];
    }
}

