/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.jsp.discoverer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.jsp.JspFactory;
import org.eclipse.modisco.jee.jsp.Model;
import org.eclipse.modisco.jee.jsp.discoverer.JspActivator;
import org.eclipse.modisco.jee.jsp.discoverer.parser.JSPLexer;
import org.eclipse.modisco.jee.jsp.discoverer.parser.JSPParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJspDiscoverer<T>
extends AbstractModelDiscoverer<T> {
    public static final String JSP_FILE_EXTENSION = "jsp";
    public static final String[] EXTENSION_LIST = new String[]{"jsp", "jspf", "jspx", "jtpl", "jsv", "jsw", "tag", "tagf", "tagx", "htm", "html"};
    private static ArrayList<String> extensionList = null;

    protected static JspFactory getEFactory() {
        return JspFactory.eINSTANCE;
    }

    protected static List<String> getExtensionList() {
        if (extensionList == null) {
            extensionList = new ArrayList();
            String[] stringArray = EXTENSION_LIST;
            int n = EXTENSION_LIST.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                extensionList.add(extension);
                ++n2;
            }
        }
        return extensionList;
    }

    public static boolean isJspExtension(String extension) {
        boolean result = false;
        if (extension != null) {
            result = AbstractJspDiscoverer.getExtensionList().contains(extension.toLowerCase());
        }
        return result;
    }

    protected static void discoverFile(File file, Model model) throws DiscoveryException {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            ANTLRInputStream input = new ANTLRInputStream((InputStream)inputStream);
            JSPLexer lexer = new JSPLexer((CharStream)input, file.getName());
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            JSPParser parser = new JSPParser((TokenStream)tokens);
            parser.page(file.getPath(), file.getName());
            model.getPages().add((Object)parser.page);
        }
        catch (OutOfMemoryError e) {
            MoDiscoLogger.logError((Throwable)e, (String)("Discovery encountered an error on \"" + file.getAbsolutePath() + "\"."), (Plugin)JspActivator.getDefault());
        }
        catch (Exception e) {
            throw new DiscoveryException("Error discovering JSP \"" + file.getAbsolutePath() + "\".", (Throwable)e);
        }
    }

    protected static void discoverDirectory(File directory, Model model) throws DiscoveryException {
        File[] files;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                AbstractJspDiscoverer.discoverDirectory(file, model);
            } else {
                String fileExtension = new Path(file.getPath()).getFileExtension();
                if (AbstractJspDiscoverer.isJspExtension(fileExtension)) {
                    AbstractJspDiscoverer.discoverFile(file, model);
                }
            }
            ++n2;
        }
    }
}

