/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.facet.efacet.core.internal.CastUtils;
import org.eclipse.modisco.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmfUtils {
    private EmfUtils() {
    }

    public static void checkAssignment(Object value, ETypedElement eTypedElement) throws UnmatchingExpectedTypeException {
        String typedElementName = EmfUtils.getTypeElementDescription(eTypedElement);
        if (eTypedElement.getEType() == null) {
            throw new IllegalArgumentException(String.valueOf(typedElementName) + " has a null type");
        }
        if (value == null && eTypedElement.getLowerBound() > 0) {
            throw new IllegalArgumentException("The assigned value cannot be null for " + typedElementName + " because multiplicity is " + eTypedElement.getLowerBound() + ".." + eTypedElement.getUpperBound());
        }
        if (value != null) {
            if (eTypedElement.getUpperBound() == 1) {
                if (!eTypedElement.getEType().isInstance(value)) {
                    throw new IllegalArgumentException("Type mismatch for " + EcoreUtil.getURI((EObject)eTypedElement) + ": expected '" + eTypedElement.getEType().getName() + "' but got '" + value.getClass().getName() + "'.");
                }
            } else {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Type mismatch for " + typedElementName + "': expected a List because the parameter is multiplicity-many. But got a " + value.getClass().getName() + "'.");
                }
                List argumentList = (List)value;
                try {
                    CastUtils.checkTypeOfAllListElements(argumentList, eTypedElement.getEType().getInstanceClass(), true);
                }
                catch (UnmatchingExpectedTypeException e) {
                    throw new UnmatchingExpectedTypeException("Type mismatch for an element of the list value " + typedElementName, e);
                }
            }
        }
    }

    private static String getTypeElementDescription(ETypedElement eTypedElement) {
        String containerName = "";
        if (eTypedElement.eContainer() instanceof ENamedElement) {
            ENamedElement namedContainer = (ENamedElement)eTypedElement.eContainer();
            containerName = "the " + namedContainer.eClass().getName() + " named '" + namedContainer.getName() + "'";
        }
        return "the " + eTypedElement.eClass().getName() + " named '" + eTypedElement.getName() + "' in " + containerName;
    }

    public static Object ecoreInvoke(EObject eObject, EOperation operation, Object ... arguments) throws InvocationTargetException {
        BasicEList operationParams = new BasicEList();
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            operationParams.add(param);
            ++n2;
        }
        return eObject.eInvoke(operation, (EList)operationParams);
    }

    public static <T> T checkAssignment(EStructuralFeature eStructuralFeature, Class<T> expectedType, Object value) throws UnmatchingExpectedTypeException {
        if (eStructuralFeature.isMany() && expectedType != null) {
            if (expectedType != Object.class && !Collection.class.isAssignableFrom(expectedType)) {
                throw new UnmatchingExpectedTypeException("The required eStructuralFeature is multi-valued, so expectedType must be a subtype of Collection.");
            }
            if (!expectedType.isInstance(value)) {
                throw new UnmatchingExpectedTypeException("The derived typed element did not evaluate to the expected type", Collection.class, value);
            }
        }
        return CastUtils.castToExpectedType(value, expectedType);
    }
}

