/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class IntIntTreeMap
extends AbstractTreeMap
implements IntIntSortedMap {
    private IntEntry dummy = new IntEntry(Integer.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public IntIntTreeMap() {
        this(null, false);
    }

    public IntIntTreeMap(boolean allowDuplicates) {
        this(null, allowDuplicates);
    }

    public IntIntTreeMap(LiteralComparator comparator) {
        this(comparator, false);
    }

    public IntIntTreeMap(LiteralComparator comparator, boolean allowDuplicates) {
        super(comparator, allowDuplicates);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(int key) {
        return this.find(key, 0) != NIL;
    }

    public int get(int key) {
        AbstractTreeMap.Entry ret = this.find(key, 0);
        return ret == NIL ? Integer.MIN_VALUE : ret.val;
    }

    public int put(int key, int value) {
        AbstractTreeMap.Entry t = this.root;
        this.lastOrder = 0;
        if (t == NIL) {
            this.incrementSize(true);
            this.root = new IntEntry(key, value, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = key;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int cmp;
            if ((cmp = this.compare(this.dummy, t)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != NIL) {
                    t = t.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                t.left = new IntEntry(key, value, t, this.lastOrder);
                this.fixUpInsert(t.left);
                return Integer.MIN_VALUE;
            }
            if (t.right == NIL) break;
            t = t.right;
        }
        this.incrementSize(this.lastOrder == 0);
        t.right = new IntEntry(key, value, t, this.lastOrder);
        this.fixUpInsert(t.right);
        return Integer.MIN_VALUE;
    }

    public int remove(int key) {
        AbstractTreeMap.Entry x = this.allowDuplicates ? this.findPredecessor(key, Integer.MAX_VALUE) : this.find(key, 0);
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        int val = x.val;
        this.remove(x);
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public int remove(int key, int val) {
        x = this.findCeiling(key, 0);
        if (x != IntIntTreeMap.NIL && x.getIntKey() != key) {
            x = this.successor(x);
        }
        if (x != IntIntTreeMap.NIL && x.getIntKey() == key) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            x = this.successor(x);
lbl7:
            // 2 sources

            ** while (x.val != val && x != IntIntTreeMap.NIL)
        }
lbl8:
        // 1 sources

        if (x == IntIntTreeMap.NIL) {
            return -2147483648;
        }
        this.remove(x);
        return val;
    }

    public int getLast(int key) {
        AbstractTreeMap.Entry ret = this.findPredecessor(key, Integer.MAX_VALUE);
        return ret == NIL || ((IntEntry)ret).key != key ? Integer.MIN_VALUE : ret.val;
    }

    public int getPreviousValue(int key, int value) {
        AbstractTreeMap.Entry cur = this.find(key, value);
        return this.predecessor((AbstractTreeMap.Entry)cur).val;
    }

    public int getNextValue(int key, int value) {
        AbstractTreeMap.Entry cur = this.find(key, value);
        return this.successor((AbstractTreeMap.Entry)cur).val;
    }

    public int firstKey() {
        return this.minimum(this.root).getIntKey();
    }

    public int lastKey() {
        return this.maximum(this.root).getIntKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(int fromKey, boolean fromInc, int toKey, boolean toInc) {
        AbstractTreeMap.Entry end;
        AbstractTreeMap.Entry start;
        if (this.cmp.compare(fromKey, toKey) <= 0) {
            start = this.findCeiling(fromKey, fromInc ? 0 : Integer.MAX_VALUE);
            end = this.findCeiling(toKey, toInc ? Integer.MAX_VALUE : 0);
        } else {
            start = this.findCeiling(fromKey, fromInc ? Integer.MAX_VALUE : 0);
            start = this.predecessor(start);
            end = this.findCeiling(toKey, toInc ? 0 : Integer.MAX_VALUE);
            end = this.predecessor(end);
        }
        return new KeyIterator(start, end);
    }

    public IntIterator valueRangeIterator(int fromKey, boolean fromInc, int toKey, boolean toInc) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(fromKey, fromInc, toKey, toInc));
    }

    protected int compare(AbstractTreeMap.Entry e1, AbstractTreeMap.Entry e2) {
        int c = this.cmp.compare(e1.getIntKey(), e2.getIntKey());
        if (this.allowDuplicates && c == 0) {
            c = e1.order < e2.order ? -1 : (e1.order > e2.order ? 1 : 0);
            this.lastOrder = 1 + (c < 0 ? e1.order : e2.order);
        }
        return c;
    }

    private AbstractTreeMap.Entry find(int key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.find(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findPredecessor(int key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findPredecessor(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findCeiling(int key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findCeiling(this.dummy);
        return e;
    }

    static class IntEntry
    extends AbstractTreeMap.Entry {
        int key;

        public IntEntry(int key, int val) {
            super(val);
            this.key = key;
        }

        public IntEntry(int key, int val, AbstractTreeMap.Entry parent, int order) {
            super(val, parent, order);
            this.key = key;
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry e) {
            return e instanceof IntEntry && this.key == ((IntEntry)e).key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntEntry)) {
                return false;
            }
            IntEntry e = (IntEntry)o;
            return this.key == e.key && this.val == e.val;
        }

        public int hashCode() {
            int khash = this.key;
            int vhash = this.val;
            return khash ^ vhash ^ this.order;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry x) {
            super.copyFields(x);
            this.key = x.getIntKey();
        }
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry start, AbstractTreeMap.Entry end) {
            super(start, end);
        }

        public boolean isIntSupported() {
            return true;
        }

        public int nextInt() {
            return this.nextEntry().getIntKey();
        }
    }
}

