/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.DiscoveryIteration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportingUtilities {
    private static final int UNIT_0 = 0;
    private static final int UNIT_1 = 1;
    private static final int UNIT_2 = 2;
    private static final int UNIT_3 = 3;
    private static final int UNIT_4 = 4;
    private static final int UNIT_5 = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;

    private ReportingUtilities() {
    }

    public static double maxExecutionTime(Collection<DiscoveryIteration> iterations) {
        double maxExecutionTime = 0.0;
        for (DiscoveryIteration iteration : iterations) {
            maxExecutionTime = Math.max(iteration.getDiscoveryTimeInSeconds(), maxExecutionTime);
        }
        return maxExecutionTime;
    }

    public static double maxSaveTime(Collection<DiscoveryIteration> iterations) {
        double maxSaveTime = 0.0;
        for (DiscoveryIteration iteration : iterations) {
            maxSaveTime = Math.max(iteration.getSaveTimeInSeconds(), maxSaveTime);
        }
        return maxSaveTime;
    }

    public static String sizeWithUnit(Double value) {
        double result = value;
        int unit = 0;
        while (result > 1024.0) {
            result /= 1024.0;
            ++unit;
        }
        if (unit > 0) {
            return String.valueOf(String.format("%.1f", result)) + " " + ReportingUtilities.unitName(unit);
        }
        return String.valueOf((int)result) + " " + ReportingUtilities.unitName(unit);
    }

    private static String unitName(int unit) {
        switch (unit) {
            case 0: {
                return "bytes";
            }
            case 1: {
                return "KiB";
            }
            case 2: {
                return "MiB";
            }
            case 3: {
                return "GiB";
            }
            case 4: {
                return "TiB";
            }
            case 5: {
                return "PiB";
            }
        }
        throw new IllegalArgumentException("" + unit);
    }

    public static String timeWithUnit(Double seconds) {
        Double remainder = seconds;
        int minutes = 0;
        while (remainder > 60.0) {
            remainder = remainder - 60.0;
            ++minutes;
        }
        if (minutes > 0) {
            return String.valueOf(minutes) + "m " + remainder.intValue() + "s";
        }
        return String.valueOf(String.format("%.2f", remainder)) + "s";
    }

    public static int indexOf(List<Object> list, Object object) {
        return list.indexOf(object);
    }
}

