/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.ui.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSetFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIProjectComposite
extends AbstractCellEditorComposite<IProjectSet> {
    private final Button button;
    private Text text = null;
    private IProjectSet projects = null;
    private final Composite parentControl;

    public MultiIProjectComposite(Composite parent) {
        this(parent, 0);
    }

    public MultiIProjectComposite(Composite parent, int style) {
        super(parent);
        this.parentControl = parent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData data = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiIProjectComposite.this.browseResource();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == MultiIProjectComposite.this.getParentControl().getShell() && event.widget != MultiIProjectComposite.this.getButton() && event.widget != MultiIProjectComposite.this.getText()) {
                    MultiIProjectComposite.this.fireCommit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    MultiIProjectComposite.this.fireCommit();
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    MultiIProjectComposite.this.close();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MultiIProjectComposite.this.fireChanged();
            }
        });
        this.text.forceFocus();
    }

    protected Button getButton() {
        return this.button;
    }

    protected Text getText() {
        return this.text;
    }

    protected void commit() {
        this.fireCommit();
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }

    public IProjectSet getValue() {
        return this.projects;
    }

    protected void browseResource() {
        Object[] result;
        WorkbenchContentProvider projectsContentProvider = new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                Object[] iProjects = ((IWorkspace)element).getRoot().getProjects();
                if (iProjects == null) {
                    return new Object[0];
                }
                return iProjects;
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)ResourcesPlugin.getWorkspace(), (IStructuredContentProvider)projectsContentProvider, (ILabelProvider)new WorkbenchLabelProvider(), "Please select one or more projects");
        dialog.setMessage("Please select one or more projects");
        dialog.setTitle("Select Projects");
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length > 0) {
            IProjectSet selectedProjects = IProjectSetFactory.INSTANCE.createProjectSet();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IProject) {
                    selectedProjects.add((IProject)object);
                }
                ++n2;
            }
            this.setValue(selectedProjects);
            this.fireCommit();
        }
    }

    public void setValue(IProjectSet value) {
        this.projects = value;
        if (this.projects == null) {
            this.text.setText("");
        } else if (this.projects.size() == 1) {
            this.text.setText(this.projects.get(0).getFullPath().toString());
        } else if (this.projects.size() > 1) {
            this.text.setText("\"" + this.projects.get(0).getFullPath().toString() + "\" and " + (this.projects.size() - 1) + " more ...");
        } else {
            this.text.setText("");
        }
    }
}

