/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class RangePredicate
extends BinaryExpression
implements Predicate {
    public static final int IN_IN = 0;
    public static final int IN_EX = 1;
    public static final int EX_IN = 2;
    public static final int EX_EX = 3;
    private Expression m_middle;
    private Comparator m_cmp;

    public RangePredicate(Expression middle, Expression left, Expression right) {
        this(0, middle, left, right, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(Expression middle, Expression left, Expression right, Comparator cmp) {
        this(0, middle, left, right, cmp);
    }

    public RangePredicate(int operation, Expression middle, Expression left, Expression right) {
        this(operation, middle, left, right, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(int operation, Expression middle, Expression left, Expression right, Comparator cmp) {
        super(operation, 0, 3, left, right);
        this.m_middle = middle;
        this.m_cmp = cmp;
    }

    public Expression getMiddleExpression() {
        return this.m_middle;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(Tuple t) {
        int c1;
        Class lType = this.m_left.getType(t.getSchema());
        Class rType = this.m_right.getType(t.getSchema());
        Class mType = this.m_middle.getType(t.getSchema());
        Class sType = null;
        if (lType.isAssignableFrom(rType)) {
            sType = lType;
        } else if (rType.isAssignableFrom(lType)) {
            sType = rType;
        }
        int c2 = 0;
        if (sType != null && TypeLib.isNumericType(sType) && TypeLib.isNumericType(mType)) {
            Class type = TypeLib.getNumericType(sType, mType);
            if (type == Integer.TYPE) {
                int lo = this.m_left.getInt(t);
                int hi = this.m_right.getInt(t);
                int x = this.m_middle.getInt(t);
                c1 = ((LiteralComparator)this.m_cmp).compare(x, lo);
                c2 = ((LiteralComparator)this.m_cmp).compare(x, hi);
            } else if (type == Long.TYPE) {
                long lo = this.m_left.getLong(t);
                long hi = this.m_right.getLong(t);
                long x = this.m_middle.getLong(t);
                c1 = ((LiteralComparator)this.m_cmp).compare(x, lo);
                c2 = ((LiteralComparator)this.m_cmp).compare(x, hi);
            } else if (type == Float.TYPE) {
                float lo = this.m_left.getFloat(t);
                float hi = this.m_right.getFloat(t);
                float x = this.m_middle.getFloat(t);
                c1 = ((LiteralComparator)this.m_cmp).compare(x, lo);
                c2 = ((LiteralComparator)this.m_cmp).compare(x, hi);
            } else {
                if (type != Double.TYPE) throw new IllegalStateException();
                double lo = this.m_left.getDouble(t);
                double hi = this.m_right.getDouble(t);
                double x = this.m_middle.getDouble(t);
                c1 = ((LiteralComparator)this.m_cmp).compare(x, lo);
                c2 = ((LiteralComparator)this.m_cmp).compare(x, hi);
            }
        } else {
            Object lo = this.m_left.get(t);
            Object hi = this.m_right.get(t);
            Object x = this.m_middle.get(t);
            c1 = this.m_cmp.compare(x, lo);
            c2 = this.m_cmp.compare(x, hi);
        }
        switch (this.m_op) {
            case 0: {
                return c1 >= 0 && c2 <= 0;
            }
            case 1: {
                return c1 >= 0 && c2 < 0;
            }
            case 2: {
                return c1 > 0 && c2 <= 0;
            }
            case 3: {
                return c1 > 0 && c2 < 0;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    public Class getType(Schema s) {
        return Boolean.TYPE;
    }

    public Object get(Tuple t) {
        return this.getBoolean(t) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
        v.down();
        this.m_left.visit(v);
        v.up();
        v.down();
        this.m_middle.visit(v);
        v.up();
        v.down();
        this.m_right.visit(v);
        v.up();
    }

    protected void addChildListeners() {
        super.addChildListeners();
        this.m_middle.addExpressionListener(this);
    }

    protected void removeChildListeners() {
        super.removeChildListeners();
        this.m_middle.removeExpressionListener(this);
    }

    public String toString() {
        String lop = "?";
        String rop = "?";
        switch (this.m_op) {
            case 0: {
                rop = "<=";
                lop = "<=";
                break;
            }
            case 1: {
                lop = "<=";
                rop = "<";
                break;
            }
            case 2: {
                lop = "<";
                rop = "<=";
                break;
            }
            case 3: {
                rop = "<";
                lop = "<";
            }
        }
        return String.valueOf('(') + this.m_left.toString() + ' ' + lop + ' ' + this.m_middle.toString() + " AND " + this.m_middle.toString() + ' ' + rop + ' ' + this.m_right.toString() + ')';
    }
}

