/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.internal.catalog.DiscovererRegistry;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.osgi.util.NLS;

public final class LaunchModelUtils {
    public static final String DISCOVERER_LAUNCH_MODEL = "discoverer_launch_model";
    private static int nLaunchModel = 0;

    private LaunchModelUtils() {
    }

    public static LaunchConfiguration createLaunchConfigurationModel() {
        Resource launchResource = LaunchModelUtils.createLaunchResource();
        LaunchConfiguration launchConfigurationModel = LaunchFactory.eINSTANCE.createLaunchConfiguration();
        launchConfigurationModel.setOpenModelAfterDiscovery(true);
        launchResource.getContents().add((Object)launchConfigurationModel);
        return launchConfigurationModel;
    }

    public static Resource createLaunchResource() {
        ResourceSet resourceSet = DiscovererRegistry.INSTANCE.getResourceSet();
        Resource launchResource = resourceSet.createResource(URI.createURI((String)("http://eclipse.org/MoDisco/launchModel" + nLaunchModel++)));
        return launchResource;
    }

    public static Object getDiscoveryParameterValue(LaunchConfiguration launchConfig, DiscovererParameter parameter) {
        Object value = null;
        for (ParameterValue candidate : launchConfig.getParameterValues()) {
            if (!candidate.getParameter().getId().equals(parameter.getId())) continue;
            value = candidate.getValue();
        }
        return value;
    }

    public static void setDiscoveryParameterValue(LaunchConfiguration launchConfig, DiscovererParameter parameter, Object value) {
        ParameterValue parameterValue = null;
        for (ParameterValue candidate : launchConfig.getParameterValues()) {
            if (!candidate.getParameter().getId().equals(parameter.getId())) continue;
            parameterValue = candidate;
        }
        if (parameterValue == null) {
            parameterValue = LaunchFactory.eINSTANCE.createParameterValue();
            parameterValue.setParameter(parameter);
            launchConfig.getParameterValues().add((Object)parameterValue);
        }
        parameterValue.setValue(value);
    }

    public static String validate(LaunchConfiguration launchConfiguration) {
        IResource resource;
        DiscovererDescription discoverer = launchConfiguration.getDiscoverer();
        if (discoverer == null) {
            return Messages.DiscoverersMainTab_discovererNotFound;
        }
        EList parameterDefinitions = discoverer.getParameterDefinitions();
        for (DiscovererParameter discovererParameter : parameterDefinitions) {
            if (!discovererParameter.isRequiredInput()) continue;
            boolean hasValue = false;
            EList parameterValues = launchConfiguration.getParameterValues();
            for (ParameterValue parameterValue : parameterValues) {
                if (!parameterValue.getParameter().getId().equals(discovererParameter.getId())) continue;
                hasValue = parameterValue.getValue() != null;
                break;
            }
            if (hasValue) continue;
            return NLS.bind((String)Messages.LaunchModelUtils_valueNotSet, (Object)discovererParameter.getId());
        }
        Object source = launchConfiguration.getSource();
        if (source == null || source instanceof IWorkspaceRoot) {
            return Messages.LaunchModelUtils_sourceMustBeSet;
        }
        if (source instanceof IResource && !(resource = (IResource)source).exists()) {
            return Messages.LaunchModelUtils_sourceMustBeExistingResource;
        }
        if (!IDiscoveryManager.INSTANCE.isApplicable(discoverer, source)) {
            return Messages.LaunchModelUtils_discovererNotApplicableOnSource;
        }
        return null;
    }
}

