/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.uml2converter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.kdm.uml2converter.internal.KdmToUml2Activator;
import org.eclipse.modisco.kdm.uml2converter.internal.KdmToUmlConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelFromKdmModel
extends AbstractModelDiscoverer<IFile> {
    private static final String TARGET_EXTENSION = "uml";
    private IFile customTransformation = null;

    @Parameter(name="CUSTOM_TRANSFORMATION", description="A .asm file (compiled by ATL) containing a custom transformation to use instead of the default KDM to UML transformation.")
    public void setCustomTransformation(IFile file) {
        this.customTransformation = file;
    }

    protected IFile getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean isApplicableTo(IFile file) {
        if (!file.exists()) {
            return false;
        }
        try {
            IContentDescription contentDescription = file.getContentDescription();
            return "org.eclipse.modisco.omg.kdm.contenttype".equals(contentDescription.getContentType().getId());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            return file.toString().endsWith("_kdm.xmi");
        }
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        Resource result = null;
        String name = source.getName();
        if (name.endsWith("_kdm.xmi")) {
            name = name.substring(0, name.length() - "_kdm.xmi".length());
        }
        IPath targetPath = source.getProject().getFullPath().append(name).addFileExtension(TARGET_EXTENSION);
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)true));
        try {
            KdmToUmlConverter transfo = new KdmToUmlConverter();
            XMIResourceImpl kdmModel = new XMIResourceImpl();
            kdmModel.setURI(URI.createPlatformResourceURI((String)source.getFullPath().toString(), (boolean)true));
            kdmModel.load(null);
            Resource[] resources = null;
            resources = this.getCustomTransformation() != null ? transfo.getUML2ModelFromKDMModelWithCustomTransformation((Resource)kdmModel, false, this.getCustomTransformation().getLocationURI().toURL()) : transfo.getUML2ModelFromKDMModel((Resource)kdmModel, false);
            result = resources[0];
            this.setTargetModel(result);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
        }
    }
}

