/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer;

import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.internal.converter.MethodCallsGraphConverter;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverMethodCallsModelFromJavaProject
extends AbstractModelDiscoverer<IJavaProject> {
    public boolean isApplicableTo(IJavaProject source) {
        return source.getProject().isAccessible();
    }

    protected void basicDiscoverElement(IJavaProject javaProject, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = javaProject.getProject();
        DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
        discoverer.discoverElement((Object)javaProject, monitor);
        Resource javaModel = discoverer.getTargetModel();
        String filepath = project.getFullPath().append(project.getName()) + "_methodcalls.xmi";
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)filepath, (boolean)true));
        javaModel.setURI(this.deriveJavaModelUri());
        MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
        CallsModel model = callsConverter.convertJavaResourceToMethodCallsModel(javaModel, project.getName());
        this.createTargetModel();
        this.getTargetModel().getContents().add((Object)model);
        this.getResourceSet().getResources().add((Object)javaModel);
    }

    private URI deriveJavaModelUri() {
        String lastSegment;
        URI mainURI = this.getTargetURI();
        if (mainURI == null || mainURI.toString().trim().length() == 0) {
            mainURI = this.getDefaultTargetURI();
        }
        String baseName = (lastSegment = mainURI.lastSegment()).endsWith("_methodcalls.xmi") ? lastSegment.substring(0, lastSegment.length() - "_methodcalls.xmi".length()) : (lastSegment.endsWith(".xmi") ? lastSegment.substring(0, lastSegment.length() - ".xmi".length()) : lastSegment);
        mainURI = mainURI.trimSegments(1);
        return mainURI.appendSegment(String.valueOf(baseName) + "_java.xmi");
    }

    protected void saveTargetModel() throws IOException {
        super.saveTargetModel();
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        int flushThreshold = 65536;
        options.put("FLUSH_THRESHOLD", Integer.valueOf(65536));
        options.put("USE_FILE_BUFFER", Boolean.TRUE);
        Resource targetModel = this.getTargetModel();
        if (targetModel != null) {
            EList resources = targetModel.getResourceSet().getResources();
            for (Resource resource : resources) {
                if (resource == targetModel) continue;
                resource.save(options);
            }
        }
    }
}

