/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.JavaModelUtils;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.internal.converter.MethodCallsGraphConverter;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverMethodCallsModelFromJavaModel
extends AbstractModelDiscoverer<IFile> {
    public boolean isApplicableTo(IFile source) {
        return JavaModelUtils.isJavaModelFile((IFile)source);
    }

    protected void basicDiscoverElement(IFile file, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = file.getProject();
        IJavaProject javaProject = null;
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            throw new DiscoveryException((Throwable)e);
        }
        if (javaProject != null) {
            Resource javaResource = DiscoverMethodCallsModelFromJavaModel.loadJavaModel(file);
            String filepath = project.getFullPath().append(project.getName()) + "_methodcalls.xmi";
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)filepath, (boolean)true));
            MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
            CallsModel callsModel = callsConverter.convertJavaResourceToMethodCallsModel(javaResource, project.getName());
            this.createTargetModel();
            this.getTargetModel().getContents().add((Object)callsModel);
        }
    }

    private static Resource loadJavaModel(IFile file) throws DiscoveryException {
        Resource result = null;
        try {
            result = ModelUtils.loadModel((File)file.getLocation().toFile());
        }
        catch (IOException e) {
            throw new DiscoveryException((Throwable)e);
        }
        return result;
    }
}

