/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.modisco.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CastUtils {
    private CastUtils() {
    }

    public static <T> List<T> castToExpectedListType(Object object, Class<T> expectedType, boolean canContainsNull) throws UnmatchingExpectedTypeException {
        List<T> result = null;
        if (object != null) {
            if (!(object instanceof List)) {
                throw new UnmatchingExpectedTypeException("The parameter 'object' is not a List");
            }
            List list = (List)object;
            result = CastUtils.castToExpectedListType(list, expectedType, canContainsNull);
        }
        return result;
    }

    public static <T> List<T> castToExpectedListType(List<?> list, Class<T> expectedType, boolean canContainsNull) throws UnmatchingExpectedTypeException {
        CastUtils.checkTypeOfAllListElements(list, expectedType, canContainsNull);
        return list;
    }

    public static <T> T castToExpectedType(Object value, Class<T> expectedType) throws UnmatchingExpectedTypeException {
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new UnmatchingExpectedTypeException("Type mismatch. Expected: " + expectedType.getClass().getName() + ", got " + value.getClass().getName(), e);
        }
    }

    public static void checkTypeOfAllListElements(List<?> list, Class<?> expectedType, boolean canContainsNull) throws UnmatchingExpectedTypeException {
        if (expectedType == null) {
            return;
        }
        Iterator<?> iterator = list.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ++index;
            if (!canContainsNull && object == null) {
                throw new UnmatchingExpectedTypeException("The 'no null' constraint is violated at index " + index, expectedType, object);
            }
            if (object == null || expectedType.isInstance(object)) continue;
            throw new UnmatchingExpectedTypeException("Type mismatch at index " + index, expectedType, object);
        }
    }
}

