/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.modisco.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererListFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererListSerializer
implements ISerializer<IDiscovererList> {
    private ResourceSet rSet = new ResourceSetImpl();
    private Resource inMemoryRes;

    public DiscovererListSerializer() {
        this.rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        this.inMemoryRes = this.rSet.createResource(URI.createURI((String)"inMemory"));
    }

    public Class<IDiscovererList> getType() {
        return IDiscovererList.class;
    }

    public String serialize(IDiscovererList value) {
        this.inMemoryRes.getContents().clear();
        this.inMemoryRes.getContents().addAll((Collection)value);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.inMemoryRes.save((OutputStream)os, Collections.EMPTY_MAP);
            return ((Object)os).toString();
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Discoverer and LaunchConfiguration serialization problem", (Plugin)Activator.getDefault());
            return "";
        }
    }

    public IDiscovererList deserialize(String serializedValue) {
        IDiscovererList discovererList = IDiscovererListFactory.INSTANCE.createDiscovererList();
        ByteArrayInputStream is = new ByteArrayInputStream(serializedValue.getBytes());
        try {
            this.inMemoryRes.load((InputStream)is, Collections.EMPTY_MAP);
            discovererList.addAll((Collection<? extends Discovery>)this.inMemoryRes.getContents());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Discoverer and LaunchConfiguration deserialization problem", (Plugin)Activator.getDefault());
        }
        return discovererList;
    }
}

