/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.IModiscoBuilder;
import org.eclipse.gmt.modisco.infra.common.core.internal.validation.ValidationUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoDiscoCatalogBuilder
implements IModiscoBuilder {
    private static final String DEBUG_ID = "org.eclipse.gmt.modisco.infra.common.core/debug/MoDiscoCatalogBuilder/debug";
    static final boolean DEBUG = CommonModiscoActivator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.gmt.modisco.infra.common.core/debug/MoDiscoCatalogBuilder/debug"));

    @Override
    public void clean(IncrementalProjectBuilder builder, IProgressMonitor monitor) throws CoreException {
        IProject project = builder.getProject();
        this.getCatalog().clean(project);
        this.validateModelDeclared(project);
    }

    @Override
    public IProject[] build(IncrementalProjectBuilder builder, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        this.getCatalog();
        if (kind == 6) {
            this.fullBuild(builder);
        } else {
            IProject project = builder.getProject();
            IResourceDelta delta = builder.getDelta(project);
            if (delta == null) {
                this.fullBuild(builder);
            } else {
                this.incrementalBuild(builder, delta);
            }
        }
        return null;
    }

    private void fullBuild(IncrementalProjectBuilder builder) {
        try {
            builder.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (fileExtension != null && fileExtension.equals(MoDiscoCatalogBuilder.this.getFileExtension())) {
                        try {
                            MoDiscoCatalogBuilder.this.getCatalog().scheduleAddWSFile((IFile)resource);
                        }
                        catch (ClassCastException e) {
                            Status status = new Status(4, MoDiscoCatalogBuilder.this.getActivator().getBundle().getSymbolicName(), "Failed to build: " + resource.getProject().getName(), (Throwable)e);
                            MoDiscoCatalogBuilder.this.getActivator().getLog().log((IStatus)status);
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), "Failed to build: " + builder.getProject(), (Throwable)e);
            this.getActivator().getLog().log((IStatus)status);
        }
        this.validateModelDeclared(builder.getProject());
    }

    private void incrementalBuild(IncrementalProjectBuilder builder, IResourceDelta resourceDelta) {
        try {
            final HashSet projectsToValidate = new HashSet();
            final ArrayList toBeAdded = new ArrayList();
            final ArrayList toBeRemoved = new ArrayList();
            final ArrayList toBeUpdated = new ArrayList();
            resourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if ("plugin.xml".equals(resource.getName()) || "build.properties".equals(resource.getName())) {
                        projectsToValidate.add(resource.getProject());
                    }
                    String fileExtension = resource.getFileExtension();
                    if (resource instanceof IFile && fileExtension != null && fileExtension.equals(MoDiscoCatalogBuilder.this.getFileExtension())) {
                        IFile file = (IFile)resource;
                        projectsToValidate.add(file.getProject());
                        switch (delta.getKind()) {
                            case 1: {
                                if (DEBUG) {
                                    System.out.println(String.valueOf(MoDiscoCatalogBuilder.this.getClass().getSimpleName()) + ": ADDED: " + file);
                                }
                                toBeAdded.add(file);
                                break;
                            }
                            case 2: {
                                if (DEBUG) {
                                    System.out.println(String.valueOf(MoDiscoCatalogBuilder.this.getClass().getSimpleName()) + ": REMOVED: " + file);
                                }
                                toBeRemoved.add(file);
                                break;
                            }
                            case 4: {
                                if (DEBUG) {
                                    System.out.println(String.valueOf(MoDiscoCatalogBuilder.this.getClass().getSimpleName()) + ": CHANGED: " + file);
                                }
                                toBeUpdated.add(file);
                                break;
                            }
                            case 8: {
                                if (DEBUG) {
                                    System.out.println(String.valueOf(MoDiscoCatalogBuilder.this.getClass().getSimpleName()) + ": ADDED_PHANTOM: " + file);
                                }
                                toBeAdded.add(file);
                                break;
                            }
                            case 16: {
                                if (DEBUG) {
                                    System.out.println(String.valueOf(MoDiscoCatalogBuilder.this.getClass().getSimpleName()) + ": REMOVED_PHANTOM: " + file);
                                }
                                toBeRemoved.add(file);
                                break;
                            }
                            default: {
                                MoDiscoLogger.logError("Unknown delta kind: " + delta.getKind(), MoDiscoCatalogBuilder.this.getActivator());
                            }
                        }
                    }
                    return true;
                }
            });
            for (IFile file : toBeRemoved) {
                this.getCatalog().scheduleRemoveWSFile(file);
            }
            for (IFile file : toBeAdded) {
                this.getCatalog().scheduleAddWSFile(file);
            }
            for (IFile file : toBeUpdated) {
                this.getCatalog().scheduleUpdateWSFile(file);
            }
            for (IProject project : projectsToValidate) {
                this.validateModelDeclared(project);
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError(e, "Failed to build: " + builder.getProject(), this.getActivator());
        }
    }

    private void validateModelDeclared(IProject project) {
        if (this.getRegistrationExtensionPoint() != null) {
            ValidationUtils.validateRegistered(project, this.getFileExtension(), this.getMarkerType(), this.getElementType(), this.getRegistrationExtensionPoint());
        }
    }

    protected abstract AbstractMoDiscoCatalog getCatalog();

    protected abstract String getElementType();

    protected abstract String getRegistrationExtensionPoint();

    protected abstract String getMarkerType();

    protected abstract String getFileExtension();

    protected abstract Plugin getActivator();
}

