/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.backend.BackendFacade;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.syslib.FileOutlet;
import org.eclipse.xtend.backend.syslib.UriBasedPostprocessor;
import org.eclipse.xtend.backend.types.CompositeTypesystemFactory;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendComponent
extends AbstractWorkflowComponent2 {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String _invoke;
    protected List<String> _parameters;
    protected final List<String> _advice = new ArrayList<String>();
    protected String _middleEndClass;
    protected Set<String> _typeSystemClasses;
    protected Collection<Outlet> _outlets;

    protected void invokeInternal(WorkflowContext workflowCtx, ProgressMonitor monitor, Issues issues) {
        BackendTypesystem ts = this.createTypesystem();
        MiddleEnd me = MiddleEndFactory.create(ts, this.createMiddleEnds());
        ExecutionContext execCtx = BackendFacade.createExecutionContext(me.createEmptyFdc(), ts, false);
        HashMap variables = new HashMap();
        String[] stringArray = workflowCtx.getSlotNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            execCtx.getLocalVarContext().getLocalVars().put(name, workflowCtx.get(name));
            ++n2;
        }
        List<Object> params = this.retrieveParams(execCtx);
        this.registerOutlets(execCtx, this._outlets);
        BackendFacade.invoke(execCtx, new QualifiedName(this._invoke), params);
    }

    public String getInvoke() {
        return this._invoke;
    }

    public void setInvoke(String invoke) {
        this._invoke = invoke;
    }

    public List<String> getParameters() {
        return this._parameters;
    }

    public void addParameters(String parameter) {
        this._parameters.add(parameter);
    }

    public Collection<Outlet> getOutlets() {
        return this._outlets;
    }

    public void addOutlets(Outlet outlet) {
        this._outlets.add(outlet);
    }

    public List<String> get_advice() {
        return this._advice;
    }

    protected BackendTypesystem createTypesystem() {
        return CompositeTypesystemFactory.INSTANCE.createTypesystemFromClassNames(this._typeSystemClasses);
    }

    protected List<LanguageSpecificMiddleEnd> createMiddleEnds() {
        List<LanguageSpecificMiddleEnd> me = null;
        try {
            Class<?> middleEndClass = Class.forName(this._middleEndClass);
            me = LanguageContributor.INSTANCE.getFreshMiddleEnds(this.createSpecificParams());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return me;
    }

    protected Map<Class<?>, Object> createSpecificParams() {
        return null;
    }

    protected List<Object> retrieveParams(ExecutionContext execCtx) {
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, Object> localVars = execCtx.getLocalVarContext().getLocalVars();
        for (String paramExpr : this._parameters) {
            params.add(localVars.get(paramExpr));
        }
        return params;
    }

    private void registerOutlets(ExecutionContext ctx, Collection<Outlet> outlets) {
        for (Outlet oldOutlet : outlets) {
            FileOutlet newOutlet = new FileOutlet();
            newOutlet.setAppend(oldOutlet.isAppend());
            newOutlet.setBaseDir(new File(oldOutlet.getPath()));
            if (oldOutlet.getFileEncoding() != null) {
                newOutlet.setFileEncoding(oldOutlet.getFileEncoding());
            }
            newOutlet.setOverwrite(oldOutlet.isOverwrite());
            String outletName = oldOutlet.getName() != null ? oldOutlet.getName() : "OUT";
            ctx.getFunctionDefContext().invoke(ctx, new QualifiedName("registerOutlet"), Arrays.asList(outletName, newOutlet));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Outlet {
        private String _name;
        private String _path;
        private String _fileEncoding;
        private boolean _append;
        private boolean _overwrite;
        private List<UriBasedPostprocessor> _postProcessor;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getPath() {
            return this._path;
        }

        public void setPath(String path) {
            this._path = path;
        }

        public String getFileEncoding() {
            return this._fileEncoding;
        }

        public void setFileEncoding(String fileEncoding) {
            this._fileEncoding = fileEncoding;
        }

        public boolean isAppend() {
            return this._append;
        }

        public void setAppend(boolean append) {
            this._append = append;
        }

        public boolean isOverwrite() {
            return this._overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this._overwrite = overwrite;
        }

        public List<UriBasedPostprocessor> getPostProcessor() {
            return this._postProcessor;
        }

        public void addPostProcessor(UriBasedPostprocessor postProcessor) {
            this._postProcessor.add(postProcessor);
        }
    }
}

