/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.internal;

import java.util.List;
import org.eclipse.xtend.backend.common.EfficientLazyString;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.FunctionInvoker;
import org.eclipse.xtend.backend.util.DoubleKeyCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionInvokerImpl
implements FunctionInvoker {
    private final DoubleKeyCache<Function, List<?>, Object> _cache = new DoubleKeyCache<Function, List<?>, Object>(){

        @Override
        protected Object create(Function f, List<?> params) {
            Object result = FunctionInvokerImpl.this.invoke(f, FunctionInvokerImpl.this._ctx, params);
            if (result instanceof EfficientLazyString) {
                ((EfficientLazyString)result).makeImmutable();
            }
            return result;
        }
    };
    private ExecutionContext _ctx;

    private Object invoke(Function f, ExecutionContext ctx, List<?> params) {
        FunctionDefContext oldFdc = ctx.getFunctionDefContext();
        ctx.setFunctionDefContext(f.getFunctionDefContext());
        try {
            Object object = f.invoke(ctx, params.toArray());
            return object;
        }
        finally {
            ctx.setFunctionDefContext(oldFdc);
        }
    }

    @Override
    public Object invoke(ExecutionContext ctx, Function f, List<?> params) {
        if (f.isCached()) {
            this._ctx = ctx;
            return this._cache.get(f, params);
        }
        return this.invoke(f, ctx, params);
    }
}

