/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDResourceSet;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDManagerView
implements XSDManager {
    private static int counter = 0;
    private int id = counter++;
    private OawXSDResourceSet manager;
    private Set<EPackage> packages = new HashSet<EPackage>();
    private Set<URI> uris = new HashSet<URI>();

    public XSDManagerView(OawXSDResourceSet manager) {
        this.manager = manager;
    }

    @Override
    public void clear() {
        for (URI uri : this.uris) {
            this.manager.remove(uri);
        }
        this.uris.clear();
        this.packages.clear();
    }

    @Override
    public EPackage.Registry getPackageRegistry() {
        return this.manager.getPackageRegistry();
    }

    @Override
    public List<EPackage> getPackages() {
        ArrayList<EPackage> r = new ArrayList<EPackage>();
        r.addAll(this.packages);
        r.addAll(this.manager.getPackages(this.uris));
        return r;
    }

    @Override
    public boolean hasErrors() {
        return this.manager.hasErrors();
    }

    @Override
    public boolean isEmpty() {
        System.out.println("XSManager" + this.id + " isempty:" + this.packages + ", " + this.uris);
        return this.packages.isEmpty() && this.uris.isEmpty();
    }

    @Override
    public void loadAndGenerate(URI uri) {
        this.uris.add(uri);
        this.manager.loadAndGenerate(uri);
    }

    @Override
    public void markDirty(URI uri) {
        this.uris.add(uri);
        this.manager.markDirty(uri);
    }

    @Override
    public void registerPackage(EPackage pkg) {
        this.packages.add(pkg);
        this.manager.registerPackage(pkg);
    }

    @Override
    public void reloadDirty(ProgressMonitor pm) {
        this.manager.reloadDirty(pm);
    }

    @Override
    public void remove(URI uri) {
        this.uris.remove(uri);
        this.manager.remove(uri);
    }

    public String toString() {
        ArrayList<String> i = new ArrayList<String>();
        for (EPackage pkg : this.getPackages()) {
            if (pkg != null) {
                i.add(pkg.getName());
                continue;
            }
            i.add("(null!)");
        }
        return String.valueOf(this.getClass().getSimpleName()) + this.id + "-" + this.manager.getID() + i.toString();
    }

    @Override
    public void unregisterPackage(EPackage pkg) {
        this.packages.add(pkg);
        this.manager.unregisterPackage(pkg);
    }
}

