/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.types;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.middleend.xtend.internal.types.TypeToBackendTypeMapper;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EClassType;
import org.eclipse.xtend.typesystem.emf.EDataTypeType;
import org.eclipse.xtend.typesystem.emf.EEnumType;

public class EmfTypeToBackendTypeMapper
extends TypeToBackendTypeMapper {
    private static final Log _log = LogFactory.getLog(EmfTypeToBackendTypeMapper.class);
    private EmfTypesystem _emfTypes = null;

    public EmfTypeToBackendTypeMapper(BackendTypesystem ts) {
        try {
            if (ts instanceof EmfTypesystem) {
                this._emfTypes = (EmfTypesystem)ts;
            } else if (ts instanceof CompositeTypesystem) {
                for (BackendTypesystem bts : ((CompositeTypesystem)ts).getInner()) {
                    if (!(bts instanceof EmfTypesystem)) continue;
                    this._emfTypes = (EmfTypesystem)bts;
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Check project setup for typesystems", (Throwable)e);
        }
    }

    public BackendType convertToBackendType(Type t) {
        if (t instanceof EClassType) {
            return this.convertEClassType(t);
        }
        if (t instanceof EDataTypeType) {
            return this.convertEDataTypeType(t);
        }
        if (t instanceof EEnumType) {
            return this.convertEEnumType(t);
        }
        if (t instanceof org.eclipse.xtend.typesystem.emf.EObjectType) {
            return EObjectType.INSTANCE;
        }
        return null;
    }

    private BackendType convertEClassType(Type t) {
        EClass eClass = (EClass)this.getField(t, "eClass");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEDataTypeType(Type t) {
        EDataType eClass = (EDataType)this.getField(t, "dataType");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEEnumType(Type t) {
        EEnum eClass = (EEnum)this.getField(t, "eEnum");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }
}

