/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EmfMetaModel;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;

public abstract class UML2MetaModelBase
extends EmfRegistryMetaModel {
    private EmfMetaModel ecoreMetaModel = new EmfMetaModel();

    public UML2MetaModelBase() {
        this.ecoreMetaModel.setMetaModelPackage(EcorePackage.class.getName());
    }

    public UML2MetaModelBase(EPackage metamodel) {
        this.ecoreMetaModel.setMetaModelPackage(EcorePackage.class.getName());
        EPackage.Registry.INSTANCE.put((Object)metamodel.getNsURI(), (Object)metamodel);
    }

    public Type getTypeForName(String typeName) {
        Type result;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        if (typeName.startsWith("UML::")) {
            typeName = "uml::" + typeName.substring(5);
        }
        if ((result = this.getPrimitive(typeName)) != null) {
            return result;
        }
        result = super.getTypeForName(typeName);
        if (result != null) {
            return result;
        }
        result = this.ecoreMetaModel.getTypeForName(typeName);
        return result;
    }

    public Type getTypeForEClassifier(EClassifier element) {
        Type result = this.getPrimitive(this.getFullyQualifiedName((ENamedElement)element));
        if (result != null) {
            return result;
        }
        result = super.getTypeForEClassifier(element);
        if (result != null) {
            return result;
        }
        result = this.ecoreMetaModel.getTypeForEClassifier(element);
        return result;
    }

    private Type getPrimitive(String typeName) {
        if (PrimitiveType.STRING.isSupported(typeName)) {
            return this.getTypeSystem().getStringType();
        }
        if (PrimitiveType.BOOLEAN.isSupported(typeName)) {
            return this.getTypeSystem().getBooleanType();
        }
        if (PrimitiveType.INTEGER.isSupported(typeName)) {
            return this.getTypeSystem().getIntegerType();
        }
        if (PrimitiveType.REAL.isSupported(typeName)) {
            return this.getTypeSystem().getRealType();
        }
        return null;
    }

    public void setTypeSystem(TypeSystem typeSystem) {
        super.setTypeSystem(typeSystem);
        this.ecoreMetaModel.setTypeSystem(typeSystem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PrimitiveType {
        BOOLEAN("uml::Boolean", "UMLPrimitiveTypes::Boolean", "types::Boolean", "EcorePrimitiveTypes::EBoolean", "EcorePrimitiveTypes::EBooleanObject"),
        INTEGER("uml::Integer", "uml::UnlimitedNatural", "UMLPrimitiveTypes::Integer", "UMLPrimitiveTypes::UnlimitedNatural", "types::Integer", "types::UnlimitedNatural", "EcorePrimitiveTypes::EIntegerObject", "EcorePrimitiveTypes::EInt"),
        STRING("uml::String", "UMLPrimitiveTypes::String", "types::String", "EcorePrimitiveTypes::EString"),
        REAL("uml::Real", "UMLPrimitiveTypes::Real", "types::Real", "EcorePrimitiveTypes::EDouble", "EcorePrimitiveTypes::EDoubleObject", "EcorePrimitiveTypes::EFloat", "EcorePrimitiveTypes::EFloatObject");

        private String[] supportedTypeNames;

        private PrimitiveType(String ... supportedTypeNames) {
            this.supportedTypeNames = supportedTypeNames;
        }

        public boolean isSupported(String typeName) {
            String[] stringArray = this.supportedTypeNames;
            int n = this.supportedTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedTypeName = stringArray[n2];
                if (supportedTypeName.equalsIgnoreCase(typeName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

