/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types;

import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProperty
implements Property {
    protected final BackendType _owner;
    protected final String _name;
    protected final boolean _isReadable;
    protected final boolean _isWritable;
    protected final JavaBuiltinConverter _converter;

    public AbstractProperty(BackendType owner, Class<?> javaType, String name, boolean isReadable, boolean isWritable) {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        this._owner = owner;
        this._name = name;
        this._isReadable = isReadable;
        this._isWritable = isWritable;
        this._converter = JavaBuiltinConverterFactory.getConverter(javaType);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public BackendType getOwner() {
        return this._owner;
    }

    @Override
    public final Object get(ExecutionContext ctx, Object o) {
        return this._converter.javaToBackend(this.getRaw(ctx, o));
    }

    @Override
    public final void set(ExecutionContext ctx, Object o, Object newValue) {
        this.setRaw(ctx, o, this._converter.backendToJava(newValue));
    }

    protected abstract Object getRaw(ExecutionContext var1, Object var2);

    public void setRaw(ExecutionContext ctx, Object o, Object newValue) {
        throw new IllegalStateException("property " + this._name + " of type " + this._owner.getName() + " can not be set");
    }

    @Override
    public boolean isReadable() {
        return this._isReadable;
    }

    @Override
    public boolean isWritable() {
        return this._isWritable;
    }
}

