/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.syslib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.syslib.InMemoryPostprocessor;
import org.eclipse.xtend.backend.syslib.Outlet;
import org.eclipse.xtend.backend.syslib.UriBasedPostprocessor;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.backend.util.NullWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileOutlet
implements Outlet {
    private File _baseDir;
    private String _fileEncoding = System.getProperty("file.encoding");
    private boolean _overwrite = false;
    private boolean _append = false;
    private final List<InMemoryPostprocessor> _inMemoryPp = new ArrayList<InMemoryPostprocessor>();
    private final List<UriBasedPostprocessor> _uriBasedPp = new ArrayList<UriBasedPostprocessor>();

    public void register(InMemoryPostprocessor pp) {
        this._inMemoryPp.add(pp);
    }

    public void register(UriBasedPostprocessor pp) {
        this._uriBasedPp.add(pp);
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public void setBaseDir(File baseDir) {
        this._baseDir = baseDir;
    }

    public String getFileEncoding() {
        return this._fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this._fileEncoding = fileEncoding;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    public boolean isAppend() {
        return this._append;
    }

    @Override
    public Writer createWriter(String filename) {
        return this.createWriter(filename, this._append);
    }

    @Override
    public Writer createWriter(String filename, boolean append) {
        try {
            File target = this.createTargetFile(filename);
            if (target.exists() && !this._overwrite) {
                return new NullWriter();
            }
            File f = new File(this._baseDir, filename);
            File parentDir = f.getParentFile();
            if (parentDir.isFile()) {
                throw new IllegalStateException("'" + parentDir + "' exists but is no directory.");
            }
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f, append);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            if (this._fileEncoding == null) {
                return new OutputStreamWriter(bos);
            }
            return new OutputStreamWriter((OutputStream)bos, this._fileEncoding);
        }
        catch (IOException exc) {
            ErrorHandler.handle(exc);
            return null;
        }
    }

    private File createTargetFile(String filename) {
        return new File(this._baseDir, filename);
    }

    @Override
    public String createUri(String filename) {
        return this.createTargetFile(filename).getPath().replace("\\", "/");
    }

    @Override
    public List<InMemoryPostprocessor> getInMemoryPostprocessors() {
        return this._inMemoryPp;
    }

    @Override
    public List<UriBasedPostprocessor> getUriBasedPostprocessors() {
        return this._uriBasedPp;
    }
}

