/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.check.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend.check.ui.editor.CheckEditor;
import org.eclipse.xtend.check.ui.editor.CheckHyperlinkDetector;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.navigation.OpenAction;

public class CheckOpenAction
extends OpenAction {
    private final CheckEditor editor;

    public CheckOpenAction(CheckEditor editor) {
        super((AbstractXtendXpandEditor)editor);
        this.editor = editor;
    }

    public void run(ITextSelection selection) {
        if (!this.checkEnabled(selection) || selection == null) {
            return;
        }
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        IRegion hyperlinkRegion = this.getHyperlinkRegion(selection);
        if (hyperlinkRegion == null) {
            return;
        }
        CheckHyperlinkDetector detector = new CheckHyperlinkDetector((IEditorPart)this.editor);
        IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)this.editor.internalGetSourceViewer(), hyperlinkRegion, false);
        if (hyperlinks != null && hyperlinks.length == 1) {
            hyperlinks[0].open();
            return;
        }
        file.getFileExtension().equals("chk");
    }
}

