/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.syslib;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtend.backend.common.EfficientLazyString;
import org.eclipse.xtend.backend.common.FutureResultHolder;
import org.eclipse.xtend.backend.syslib.FileOutlet;
import org.eclipse.xtend.backend.syslib.InMemoryPostprocessor;
import org.eclipse.xtend.backend.syslib.Outlet;
import org.eclipse.xtend.backend.syslib.UriBasedPostprocessor;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.middleend.javaannotations.AbstractExecutionContextAware;

public final class FileIoOperations
extends AbstractExecutionContextAware {
    private Map<String, Outlet> _outlets = new HashMap<String, Outlet>();
    public static final String DEFAULT_OUTLET_NAME = "OUT";

    public void registerDefaultOutlet(Outlet outlet) {
        this._outlets.put(DEFAULT_OUTLET_NAME, outlet);
    }

    public void registerDefaultOutlet(String baseDir, String fileEncoding, boolean overwrite) {
        FileOutlet fo = new FileOutlet();
        fo.setBaseDir(new File(baseDir));
        fo.setFileEncoding(fileEncoding);
        fo.setOverwrite(overwrite);
        this.registerDefaultOutlet(fo);
    }

    public void registerDefaultOutlet(String baseDir, String fileEncoding) {
        this.registerDefaultOutlet(baseDir, fileEncoding, true);
    }

    public void registerDefaultOutlet(String baseDir) {
        this.registerDefaultOutlet(baseDir, null);
    }

    public void registerOutlet(String name, Outlet outlet) {
        this._outlets.put(name, outlet);
    }

    public void registerOutlet(String name, String baseDir, String fileEncoding, boolean overwrite) {
        FileOutlet fo = new FileOutlet();
        fo.setBaseDir(new File(baseDir));
        fo.setFileEncoding(fileEncoding);
        fo.setOverwrite(overwrite);
        this.registerOutlet(name, fo);
    }

    public void registerOutlet(String name, String baseDir, String fileEncoding) {
        this.registerOutlet(name, baseDir, fileEncoding, true);
    }

    public void registerOutlet(String name, String baseDir) {
        this.registerOutlet(name, baseDir, null);
    }

    public void writeToFile(String fileName, CharSequence content) {
        this.writeToFile(DEFAULT_OUTLET_NAME, fileName, false, content);
    }

    public void writeToFile(String outletName, String fileName, CharSequence content) {
        this.writeToFile(outletName, fileName, false, content);
    }

    public void writeToFile(String fileName, boolean append, CharSequence content) {
        this.writeToFile(DEFAULT_OUTLET_NAME, fileName, append, content);
    }

    public void writeToFile(String outletName, String fileName, boolean append, CharSequence content) {
        try {
            Outlet outlet = this._outlets.get(outletName);
            if (outlet == null) {
                throw new IllegalArgumentException("no outlet '" + outletName + "' was registered.");
            }
            for (InMemoryPostprocessor pp : outlet.getInMemoryPostprocessors()) {
                content = pp.process(content, outlet.createUri(fileName));
            }
            Writer w = outlet.createWriter(fileName, append);
            try {
                if (content instanceof EfficientLazyString) {
                    ((EfficientLazyString)content).writeTo(w);
                } else {
                    w.write(content.toString());
                }
            }
            finally {
                w.close();
            }
            for (UriBasedPostprocessor pp : outlet.getUriBasedPostprocessors()) {
                pp.process(outlet.createUri(fileName));
            }
        }
        catch (IOException exc) {
            ErrorHandler.handle(exc);
        }
    }

    public void writeToFile(String fileName, FutureResultHolder content) {
        this.writeToFile(DEFAULT_OUTLET_NAME, fileName, false, content);
    }

    public void writeToFile(String outletName, String fileName, FutureResultHolder content) {
        this.writeToFile(outletName, fileName, false, content);
    }

    public void writeToFile(String fileName, boolean append, FutureResultHolder content) {
        this.writeToFile(DEFAULT_OUTLET_NAME, fileName, append, content);
    }

    public void writeToFile(String outletName, String fileName, boolean append, FutureResultHolder content) {
        try {
            Outlet outlet = this._outlets.get(outletName);
            CharSequence evaluatedContent = null;
            if (content.isReady()) {
                evaluatedContent = content.toString();
            } else {
                Object result = content.evaluate(this._ctx);
                if (result instanceof CharSequence) {
                    evaluatedContent = (CharSequence)result;
                }
            }
            if (outlet == null) {
                throw new IllegalArgumentException("no outlet '" + outletName + "' was registered.");
            }
            for (InMemoryPostprocessor pp : outlet.getInMemoryPostprocessors()) {
                evaluatedContent = pp.process(evaluatedContent, outlet.createUri(fileName));
            }
            Writer w = outlet.createWriter(fileName, append);
            try {
                if (evaluatedContent != null) {
                    w.write(evaluatedContent.toString());
                }
            }
            finally {
                w.close();
            }
            for (UriBasedPostprocessor pp : outlet.getUriBasedPostprocessors()) {
                pp.process(outlet.createUri(fileName));
            }
        }
        catch (IOException exc) {
            ErrorHandler.handle(exc);
        }
    }
}

