/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeImpl
implements Type {
    private static final Log log = LogFactory.getLog(AbstractTypeImpl.class);
    private final TypeSystem typeSystem;
    private final String _name;
    private Set<Callable> allFeatures = null;
    private final Cache<String, Property> propertyCache = new Cache<String, Property>(){

        @Override
        protected Property createNew(String name) {
            return PolymorphicResolver.getProperty(AbstractTypeImpl.this.getAllFeatures(), name, AbstractTypeImpl.this);
        }
    };
    private static final List<Type> NO_TYPES = Collections.emptyList();
    private final Cache<Pair<String, List<Type>>, Operation> operationsCache = new Cache<Pair<String, List<Type>>, Operation>(){

        @Override
        protected Operation createNew(Pair<String, List<Type>> arg0) {
            return PolymorphicResolver.getOperation(AbstractTypeImpl.this.getAllFeatures(), arg0.getFirst(), AbstractTypeImpl.this, arg0.getSecond());
        }
    };
    private Set<? extends Type> superTypes = null;

    public AbstractTypeImpl(TypeSystem typeSystem, String name) {
        this.typeSystem = typeSystem;
        this._name = name;
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public abstract Feature[] getContributedFeatures();

    public final Set<Callable> getAllFeatures() {
        if (this.allFeatures == null) {
            this.allFeatures = new HashSet<Callable>();
            this.allFeatures.addAll(Arrays.asList(this.getContributedFeatures()));
            for (Type type : this.getSuperTypes()) {
                if (type != null) {
                    this.allFeatures.addAll(type.getAllFeatures());
                    continue;
                }
                log.error((Object)("A supertype of " + this.getName() + " is null!"));
            }
        }
        return this.allFeatures;
    }

    @Override
    public StaticProperty getStaticProperty(String name) {
        return PolymorphicResolver.getStaticProperty(this.getAllFeatures(), name, this);
    }

    @Override
    public Property getProperty(String name) {
        return this.propertyCache.get(name);
    }

    @Override
    public Callable getFeature(String name, Type[] parameterTypes) {
        Property property = null;
        if (parameterTypes == null || parameterTypes.length == 0) {
            property = this.getProperty(name);
        }
        Operation operation = this.getOperation(name, parameterTypes);
        if (property != null && operation != null) {
            if (property.getOwner().equals(operation.getOwner())) {
                throw new RuntimeException();
            }
            if (property.getOwner().isAssignableFrom(operation.getOwner())) {
                return operation;
            }
            return property;
        }
        if (property != null) {
            return property;
        }
        return operation;
    }

    @Override
    public Operation getOperation(String name, Type[] parameterTypes) {
        return this.operationsCache.get(new Pair<String, List<Type>>(name, parameterTypes != null && parameterTypes.length > 0 ? Arrays.asList(parameterTypes) : NO_TYPES));
    }

    @Override
    public Set<? extends StaticProperty> getAllStaticProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), StaticProperty.class);
    }

    @Override
    public Set<? extends Property> getAllProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), Property.class);
    }

    @Override
    public Set<? extends Operation> getAllOperations() {
        return PolymorphicResolver.select(this.getAllFeatures(), Operation.class);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Type) {
            return this.getName().equals(((Type)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final boolean isAssignableFrom(Type t) {
        if (t == null) {
            return false;
        }
        if (this.equals(t)) {
            return true;
        }
        if (t.equals(this.getTypeSystem().getVoidType())) {
            return true;
        }
        return this.internalIsAssignableFrom(t);
    }

    protected boolean internalIsAssignableFrom(Type t) {
        for (Type type : t.getSuperTypes()) {
            if (!this.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        if (src == null) {
            return null;
        }
        if (targetType.isInstance(src)) {
            return src;
        }
        throw new IllegalArgumentException(String.valueOf(this.getName()) + " is not responsible for java type " + targetType.getName());
    }

    @Override
    public String getDocumentation() {
        return "";
    }

    @Override
    public Set<? extends Type> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = this.internalGetSuperTypes();
        }
        return this.superTypes;
    }

    protected Set<? extends Type> internalGetSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }
}

