/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.typesystem.xsd.OptionsEntry;
import org.eclipse.xtend.typesystem.xsd.XMLMixedContentFormater;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBeautifier
implements PostProcessor {
    protected XMLMixedContentFormater formater = this.createFormatter();
    protected String[] fileExtensions = new String[]{".xml", ".xsl", ".xsd", ".wsdd", ".wsdl"};
    protected Log log = XSDLog.getLog(this.getClass());
    protected Map<String, Object> loadOptions = this.getDefaultLoadOptions();
    protected Map<String, Object> saveOptions = this.getDefaultSaveOptions();
    protected URIConverter uriConverter;

    public void addLoadOption(OptionsEntry entry) {
        this.loadOptions.put(entry.getKey(), entry.getValue());
    }

    public void addSaveOption(OptionsEntry entry) {
        this.saveOptions.put(entry.getKey(), entry.getValue());
    }

    public void afterClose(FileHandle impl) {
    }

    public void beforeWriteAndClose(FileHandle impl) {
        String fn = impl.getAbsolutePath();
        boolean isXML = this.isXmlFile(fn);
        URI u = URI.createFileURI((String)fn);
        if (this.log.isInfoEnabled()) {
            if (isXML) {
                this.log.debug((Object)Msg.create("Beautifying ").uri(u));
            } else {
                this.log.debug((Object)Msg.create("Ignoring ").uri(u).txt(" since the file extension does not match the filter."));
            }
        }
        if (!isXML) {
            return;
        }
        ByteArrayInputStream is = null;
        String buffer = impl.getBuffer().toString().trim();
        String encoding = impl.getFileEncoding();
        if (encoding == null) {
            is = new ByteArrayInputStream(buffer.getBytes());
        } else {
            try {
                is = new ByteArrayInputStream(buffer.getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)Msg.create("Postprocessing failed for '").uri(u).txt("'. (Internal Error: ").txt(e.getMessage()).txt(")"));
                throw new RuntimeException(e);
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        if (this.uriConverter != null) {
            rs.setURIConverter(this.uriConverter);
        }
        Resource r = new GenericXMLResourceFactoryImpl().createResource(u);
        rs.getResources().add((Object)r);
        try {
            r.load((InputStream)is, this.loadOptions);
            EObject o = (EObject)r.getContents().get(0);
            this.formater.beautifyMixedContent(0, o);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            r.save((OutputStream)os, this.saveOptions);
            if (encoding == null) {
                impl.setBuffer((CharSequence)os.toString());
            } else {
                impl.setBuffer((CharSequence)os.toString(encoding));
            }
        }
        catch (IOException e) {
            this.log.error((Object)Msg.create("Postprocessing failed for '").uri(u).txt("'. (Internal Error: ").txt(e.getMessage()).txt(")"));
            throw new RuntimeException(e);
        }
    }

    protected XMLMixedContentFormater createFormatter() {
        return new XMLMixedContentFormater();
    }

    protected Map<String, Object> getDefaultLoadOptions() {
        String EXT = "http://xml.org/sax/features/external-parameter-entities";
        String VAL = "http://xml.org/sax/features/validation";
        String LOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        HashMap<String, Boolean> feat = new HashMap<String, Boolean>();
        feat.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        feat.put("http://xml.org/sax/features/validation", Boolean.FALSE);
        feat.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        XMLOptionsImpl xopt = new XMLOptionsImpl();
        xopt.setProcessAnyXML(true);
        xopt.setProcessSchemaLocations(false);
        HashMap<String, Object> opt = new HashMap<String, Object>();
        opt.put("PARSER_FEATURES", feat);
        opt.put("XML_OPTIONS", xopt);
        return opt;
    }

    protected Map<String, Object> getDefaultSaveOptions() {
        HashMap<String, Object> opt = new HashMap<String, Object>();
        opt.put("SAVE_DOCTYPE", Boolean.TRUE);
        opt.put("FORMATTED", Boolean.TRUE);
        opt.put("LINE_WIDTH", this.formater.getMaxLineWidth());
        return opt;
    }

    public boolean isXmlFile(String absolutePath) {
        int i = 0;
        while (i < this.fileExtensions.length) {
            if (absolutePath.endsWith(this.fileExtensions[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setFormatComments(boolean formatComments) {
        this.formater.setFormatComments(formatComments);
    }

    public void setMaxLineWidth(int maxLineWidth) {
        this.formater.setMaxLineWidth(maxLineWidth);
    }

    public void setUriConverter(URIConverter converter) {
        this.uriConverter = converter;
    }
}

