/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions.java.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.EfficientLazyString;
import org.eclipse.xtend.backend.functions.java.internal.ArrayConverter;
import org.eclipse.xtend.backend.functions.java.internal.ByteConverter;
import org.eclipse.xtend.backend.functions.java.internal.CharConverter;
import org.eclipse.xtend.backend.functions.java.internal.EfficientLazyStringConverter;
import org.eclipse.xtend.backend.functions.java.internal.FloatConverter;
import org.eclipse.xtend.backend.functions.java.internal.IntConverter;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;
import org.eclipse.xtend.backend.functions.java.internal.NullConverter;
import org.eclipse.xtend.backend.functions.java.internal.ParameterConverter;
import org.eclipse.xtend.backend.functions.java.internal.ShortConverter;
import org.eclipse.xtend.backend.functions.java.internal.StringBufferConverter;
import org.eclipse.xtend.backend.functions.java.internal.StringBuilderConverter;
import org.eclipse.xtend.backend.functions.java.internal.StringConverter;
import org.eclipse.xtend.backend.types.builtin.DoubleType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.LongType;
import org.eclipse.xtend.backend.types.builtin.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaBuiltinConverterFactory {
    private static final Map<Class<?>, JavaBuiltinConverter> _converters = new HashMap();
    private static final Map<Class<?>, BackendType> _additionalTypes = new HashMap();

    static {
        _converters.put(Integer.class, new IntConverter());
        _converters.put(Integer.TYPE, new IntConverter());
        _converters.put(Short.class, new ShortConverter());
        _converters.put(Short.TYPE, new ShortConverter());
        _converters.put(Byte.class, new ByteConverter());
        _converters.put(Byte.TYPE, new ByteConverter());
        _converters.put(Float.class, new FloatConverter());
        _converters.put(Float.TYPE, new FloatConverter());
        _converters.put(Character.class, new CharConverter());
        _converters.put(Character.TYPE, new CharConverter());
        _converters.put(String.class, new StringConverter());
        _converters.put(StringBuilder.class, new StringBuilderConverter());
        _converters.put(StringBuffer.class, new StringBufferConverter());
        _converters.put(EfficientLazyString.class, new EfficientLazyStringConverter());
        _additionalTypes.put(Integer.class, LongType.INSTANCE);
        _additionalTypes.put(Integer.TYPE, LongType.INSTANCE);
        _additionalTypes.put(Short.class, LongType.INSTANCE);
        _additionalTypes.put(Short.TYPE, LongType.INSTANCE);
        _additionalTypes.put(Byte.class, LongType.INSTANCE);
        _additionalTypes.put(Byte.TYPE, LongType.INSTANCE);
        _additionalTypes.put(Float.class, DoubleType.INSTANCE);
        _additionalTypes.put(Float.TYPE, DoubleType.INSTANCE);
        _additionalTypes.put(Character.class, StringType.INSTANCE);
        _additionalTypes.put(Character.TYPE, StringType.INSTANCE);
    }

    public static JavaBuiltinConverter getConverter(Class<?> cls) {
        if (cls == null) {
            return NullConverter.INSTANCE;
        }
        JavaBuiltinConverter resultRaw = _converters.get(cls);
        if (resultRaw != null) {
            return resultRaw;
        }
        if (cls.isArray()) {
            return new ArrayConverter(cls.getComponentType());
        }
        return NullConverter.INSTANCE;
    }

    public static ParameterConverter getParameterConverter(Class<?> paramClass, int index) {
        JavaBuiltinConverter inner = JavaBuiltinConverterFactory.getConverter(paramClass);
        if (inner == NullConverter.INSTANCE) {
            return null;
        }
        return new ParameterConverter(index, inner);
    }

    public static BackendType getTypeForAdditionalBuiltin(Class<?> cls) {
        BackendType resultRaw = _additionalTypes.get(cls);
        if (resultRaw != null) {
            return resultRaw;
        }
        if (cls.isArray()) {
            return ListType.INSTANCE;
        }
        return null;
    }
}

