/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSelectExpression
extends FeatureCall {
    private Identifier typeLiteral;

    public TypeSelectExpression(Identifier opName, Identifier typeLiteral) {
        super(opName, null);
        this.typeLiteral = typeLiteral;
    }

    public String getTypeName() {
        return this.typeLiteral.getValue();
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(super.toStringInternal()) + "(" + this.typeLiteral + ")";
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object targetObj = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetObj = v.getValue();
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        if (targetObj == null) {
            return ctx.handleNullEvaluation(this);
        }
        boolean cfr_ignored_0 = targetObj instanceof Collection;
        return this.executeTypeSelect((Collection)targetObj, ctx);
    }

    private Object executeTypeSelect(Collection<?> collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList();
        Type t = ctx.getTypeForName(this.typeLiteral.getValue());
        if (t == null) {
            throw new EvaluationException("Unkown type '" + this.typeLiteral + "'", (SyntaxElement)this.typeLiteral, ctx);
        }
        for (Object ele : collection) {
            if (ele == null || !t.isAssignableFrom(ctx.getType(ele))) continue;
            resultCol.add(ele);
        }
        return resultCol;
    }

    @Override
    public Type analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type targetType = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetType = (Type)v.getValue();
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        if (!(targetType instanceof ParameterizedType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Collection type expected! was : " + targetType, this.getTarget()));
            return null;
        }
        Type closureType = ctx.getTypeForName(this.typeLiteral.getValue());
        if (closureType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't find type " + this.typeLiteral, this.typeLiteral));
            return null;
        }
        return ctx.getListType(closureType);
    }
}

