/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCall
extends Expression {
    private Expression target;
    private Identifier name;

    public FeatureCall(Identifier name, Expression target) {
        this.target = target;
        this.name = name;
    }

    public Expression getTarget() {
        return this.target;
    }

    public void setTarget(Expression target) {
        this.target = target;
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public String getNameString(ExecutionContext context) {
        return this.name.getValue();
    }

    public StaticProperty getEnumLiteral(ExecutionContext ctx) {
        if (this.name.getValue().indexOf("::") != -1) {
            String typeName = this.name.getValue();
            Type type = ctx.getTypeForName(typeName = typeName.substring(0, typeName.lastIndexOf("::")));
            if (type != null) {
                String litName = this.name.getValue().substring(this.name.getValue().lastIndexOf("::") + "::".length());
                return type.getStaticProperty(litName);
            }
        }
        return null;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Type type;
        Object targetObj = null;
        if (this.target == null) {
            StaticProperty staticProp = this.getEnumLiteral(ctx);
            if (staticProp != null) {
                return staticProp.get();
            }
            Variable var = ctx.getVariable(this.getName().getValue());
            if (var != null) {
                return var.getValue();
            }
            var = ctx.getVariable("this");
            if (var != null && (targetObj = var.getValue()) == null) {
                return ctx.handleNullEvaluation(this);
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
            if (targetObj == null) {
                return ctx.handleNullEvaluation(this);
            }
        }
        if (targetObj != null) {
            Property p = ctx.findProperty(this.getName().getValue(), targetObj);
            if (p == null && targetObj instanceof Collection && !((Collection)targetObj).isEmpty()) {
                return this.invokeOnInnerElements(ctx, targetObj, "");
            }
            if (p != null) {
                return p.get(targetObj);
            }
        }
        if (this.target == null && (type = ctx.getTypeForName(this.getName().getValue())) != null) {
            return type;
        }
        if (targetObj instanceof Collection && ((Collection)targetObj).isEmpty()) {
            return targetObj;
        }
        if (this.getName().getValue().indexOf("::") != -1) {
            throw new EvaluationException("Couldn't find enum literal or type '" + this.getName().getValue() + "'", (SyntaxElement)this, ctx);
        }
        if (this.target == null) {
            throw new EvaluationException("Couldn't find type or property '" + this.getName().getValue() + "'", (SyntaxElement)this, ctx);
        }
        throw new EvaluationException("Couldn't find property '" + this.getName().getValue() + "' for type " + this.findType(targetObj, ctx).getName(), (SyntaxElement)this, ctx);
    }

    private Object invokeOnInnerElements(ExecutionContext ctx, Object targetObj, String additionalMsg) {
        Collection col = (Collection)targetObj;
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = col.iterator();
        while (iter.hasNext() && additionalMsg.length() == 0) {
            Object element = iter.next();
            Property prop = ctx.findProperty(this.getName().getValue(), element);
            if (prop == null) {
                Type type = ctx.getType(element);
                throw new EvaluationException("Couldn't find property '" + this.getName().getValue() + "' for inner type " + type + "'", (SyntaxElement)this, ctx);
            }
            Object r = prop.get(element);
            if (r instanceof Collection) {
                result.addAll((Collection)r);
                continue;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public Type analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type type;
        Type targetType = null;
        if (this.target == null) {
            StaticProperty staticProp = this.getEnumLiteral(ctx);
            if (staticProp != null) {
                return staticProp.getReturnType();
            }
            Variable var = ctx.getVariable(this.getName().getValue());
            if (var != null) {
                return (Type)var.getValue();
            }
            var = ctx.getVariable("this");
            if (var != null) {
                targetType = (Type)var.getValue();
            }
        } else {
            targetType = this.analyzeTarget(ctx, issues);
            if (targetType == null) {
                return null;
            }
        }
        String additionalMsg = "";
        if (targetType != null) {
            Property p = targetType.getProperty(this.getName().getValue());
            if (p != null) {
                return p.getReturnType();
            }
            if (p == null && targetType instanceof ParameterizedType) {
                Type innerType = ((ParameterizedType)targetType).getInnerType();
                p = innerType.getProperty(this.getName().getValue());
                if (p != null) {
                    Type rt = p.getReturnType();
                    if (rt instanceof ParameterizedType) {
                        rt = ((ParameterizedType)rt).getInnerType();
                    }
                    return ctx.getListType(rt);
                }
                additionalMsg = " or inner type '" + innerType + "'";
            }
        }
        if (this.target == null && (type = ctx.getTypeForName(this.getName().getValue())) != null) {
            return ctx.getTypeType();
        }
        if (this.target == null) {
            String txt = "";
            if (targetType != null) {
                txt = String.valueOf(targetType.getName()) + " property, ";
            }
            issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Unknown " + txt + "variable, type or enumeration literal '" + this.getName().getValue() + "'", this));
            return null;
        }
        issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Couldn't find property '" + this.getName().getValue() + "' for type '" + targetType.getName() + "'" + additionalMsg, this));
        return null;
    }

    protected Type analyzeTarget(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return this.getTarget().analyze(ctx, issues);
    }

    protected Type findType(Object value, ExecutionContext ctx) {
        Type t = ctx.getType(value);
        if (t == null) {
            throw new EvaluationException("Unkown object type : " + value.getClass().getName(), (SyntaxElement)this, ctx);
        }
        return t;
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(this.getTarget() != null ? String.valueOf(this.getTarget().toString()) + "." : "") + this.name.getValue();
    }
}

