/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;

public class TagLibraryImpl
implements TagLibrary {
    private final String id;
    private final String name;
    private final String stdPrefix;
    private final boolean deprecated;
    private final String description;
    private final Map tagDefintionsByNCName = new HashMap();
    private String[] tagNames = null;

    public TagLibraryImpl(String id, String name, String description, String stdPrefix, boolean deprecated) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.stdPrefix = stdPrefix;
        this.deprecated = deprecated;
    }

    public String getDefaultPrefix() {
        return this.stdPrefix;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLibraryId() {
        return this.id;
    }

    public String getLibraryName() {
        return this.name;
    }

    public TagDefinition getTagDefinition(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (TagDefinition)this.tagDefintionsByNCName.get(name);
    }

    public String[] getTagNames() {
        if (this.tagNames == null) {
            ArrayList tagList = new ArrayList(this.tagDefintionsByNCName.keySet());
            Collections.sort(tagList);
            this.tagNames = tagList.toArray(new String[tagList.size()]);
        }
        return this.tagNames;
    }

    public boolean hasTag(String tagNCName) {
        return this.tagDefintionsByNCName.containsKey(tagNCName);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void addTag(TagDefinition tagDefinition) {
        this.tagDefintionsByNCName.put(tagDefinition.getName(), tagDefinition);
    }
}

