/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;

public final class ElementStack {
    private final List stack = new ArrayList();

    public void push(XMLBodyElement element) {
        this.stack.add(element);
    }

    public XMLBodyElement pop() {
        if (this.stack.size() == 0) {
            throw new IllegalStateException("stack is empty");
        }
        return (XMLBodyElement)this.stack.remove(this.stack.size() - 1);
    }

    public XMLBodyElement peek() {
        if (this.stack.size() == 0) {
            throw new IllegalStateException("stack is empty");
        }
        return (XMLBodyElement)this.stack.get(this.stack.size() - 1);
    }

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public int findElementIndex(String name) {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            XMLBodyElement element = this.get(i);
            if (element.getName().equalsIgnoreCase(name)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean isAtTop(int index) {
        if (index < 0 || index >= this.stack.size()) {
            throw new IllegalArgumentException();
        }
        return index == this.stack.size() - 1;
    }

    public XMLBodyElement get(int index) {
        if (index < 0 || index >= this.stack.size()) {
            throw new IllegalArgumentException();
        }
        return (XMLBodyElement)this.stack.get(index);
    }
}

