/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.compiler.IJETCompilerState;
import org.eclipse.jet.taglib.TagLibraryReference;

public class JETCompilerState
implements Serializable,
IJETCompilerState {
    private static final long serialVersionUID = 3680891043515763347L;
    private final Map qualifiedNameByTemplatePath = new HashMap();
    private final Map templatePathByQualifiedName = new HashMap();
    private final Set projectTagLibraryReferences = new HashSet();
    private final Map templateTagLibraryReferences = new HashMap();

    public Map getTemplateMap() {
        return Collections.unmodifiableMap(this.qualifiedNameByTemplatePath);
    }

    public void addTemplate(String templatePath, String outputJavaClassName) {
        if (this.qualifiedNameByTemplatePath.containsKey(templatePath)) {
            this.removeTemplate(templatePath);
        }
        this.qualifiedNameByTemplatePath.put(templatePath, outputJavaClassName);
        this.templatePathByQualifiedName.put(outputJavaClassName, templatePath);
    }

    public void removeTemplate(String templatePath) {
        String javaClass = (String)this.qualifiedNameByTemplatePath.get(templatePath);
        this.qualifiedNameByTemplatePath.remove(templatePath);
        this.templatePathByQualifiedName.remove(javaClass);
        this.templateTagLibraryReferences.remove(templatePath);
    }

    public void clear() {
        this.qualifiedNameByTemplatePath.clear();
        this.templatePathByQualifiedName.clear();
        this.templateTagLibraryReferences.clear();
        this.projectTagLibraryReferences.clear();
    }

    public String getTemplateFromClass(String qualifiedName) {
        return (String)this.templatePathByQualifiedName.get(qualifiedName);
    }

    public void setProjectTagLibraryReferences(TagLibraryReference[] tagLibraryReferences) {
        this.projectTagLibraryReferences.clear();
        int i = 0;
        while (i < tagLibraryReferences.length) {
            this.projectTagLibraryReferences.add(tagLibraryReferences[i].getTagLibraryId());
            ++i;
        }
    }

    public void addTemplateTagLibraryReferences(String templatePath, TagLibraryReference[] references) {
        HashSet<String> idRefs = new HashSet<String>();
        int i = 0;
        while (i < references.length) {
            if (!references[i].isAutoImport()) {
                idRefs.add(references[i].getTagLibraryId());
            }
            ++i;
        }
        this.templateTagLibraryReferences.put(templatePath, idRefs);
    }

    public String[] getAllReferencedTagLibraryIds() {
        HashSet allRefs = new HashSet(this.projectTagLibraryReferences);
        Iterator i = this.templateTagLibraryReferences.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            allRefs.addAll((Set)entry.getValue());
        }
        return allRefs.toArray(new String[allRefs.size()]);
    }
}

