/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.scanners;

import java.util.ArrayList;
import org.eclipse.jet.internal.editor.configuration.JETTokenStyleManager;
import org.eclipse.jet.internal.editor.rules.WordListDetectorRule;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;

public class JETCustomTagScanner
extends RuleBasedScanner {
    public JETCustomTagScanner(JETTokenStyleManager manager, IPreferenceStore preferenceStore) {
        IToken tagElementName = manager.requestToken("__jet_custom_tag_elementName", "jet_custom_tag_foreground", "jet_default_background", "jet_custom_tag_bold", "jet_custom_tag_italic", null, "jet_custom_tag_underline");
        IToken string = manager.requestToken("__jet_custom_tag_string", "java_string", "jet_default_background", "java_string_bold", "java_string_italic", null, "java_string_underline");
        ArrayList<String> tagNames = new ArrayList<String>();
        String[] tagLibIds = TagLibraryManager.getInstance().getKnownLibraryIds();
        int i = 0;
        while (i < tagLibIds.length) {
            String id = tagLibIds[i];
            TagLibrary tagLib = TagLibraryManager.getInstance().getTagLibrary(id, true);
            String[] names = tagLib.getTagNames();
            int j = 0;
            while (j < names.length) {
                String name = names[j];
                tagNames.add(String.valueOf(tagLib.getDefaultPrefix()) + ":" + name);
                ++j;
            }
            ++i;
        }
        IRule[] rules = new IRule[]{new SingleLineRule("\"", "\"", string, '\\'), new SingleLineRule("'", "'", string, '\\'), new WordListDetectorRule(tagElementName, tagNames)};
        this.setRules(rules);
        IToken defaultReturnToken = manager.requestToken("__jet_custom_tag", "jet_custom_tag_foreground", "jet_default_background", null, null, null, null);
        this.setDefaultReturnToken(defaultReturnToken);
    }
}

