/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtension;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExtensionStatement
extends AbstractExtension {
    protected Identifier javaType;
    protected Identifier javaMethod;
    protected List<Identifier> javaParamTypes;

    public JavaExtensionStatement(Identifier name, List<DeclaredParameter> formalParameters, Identifier returnType, Identifier javaType, Identifier javaMethod, List<Identifier> javaParamTypes, boolean cached, boolean isPrivate) {
        super(name, returnType, formalParameters, cached, isPrivate);
        this.javaType = javaType;
        this.javaMethod = javaMethod;
        this.javaParamTypes = javaParamTypes;
    }

    public Identifier getJavaType() {
        return this.javaType;
    }

    public String getJavaMethodName() {
        return this.javaMethod.getValue();
    }

    @Override
    public Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        try {
            Method method = this.getJavaMethod(ctx, issues);
            if (method == null) {
                StringBuffer b = new StringBuffer();
                for (AnalysationIssue element : issues) {
                    b.append(element.toString()).append("\n");
                }
                throw new EvaluationException(String.valueOf(this.javaMethodToString()) + " not found, problems were: \n" + b, (SyntaxElement)this, ctx);
            }
            this.convertTypesToMethodSignature(ctx, method, parameters);
            return method.invoke(null, parameters);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new EvaluationException(e, (SyntaxElement)this, ctx);
        }
    }

    private void convertTypesToMethodSignature(ExecutionContext ctx, Method method, Object[] parameters) {
        Class<?>[] paramTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            Object param = parameters[i];
            parameters[i] = ctx.getType(param).convert(param, paramTypes[i]);
            ++i;
        }
    }

    private String javaMethodToString() {
        StringBuffer buff = new StringBuffer();
        Iterator<Identifier> iter = this.javaParamTypes.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return this.javaType + "." + this.javaMethod + "(" + buff + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Method getJavaMethod(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            Class clazz = null;
            clazz = ResourceLoaderFactory.createResourceLoader().loadClass(this.javaType.getValue());
            if (clazz == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't find Java type " + this.javaType.getValue(), this.javaType));
                return null;
            }
            Class[] paramTypes = new Class[this.javaParamTypes.size()];
            int i = 0;
            int x = this.javaParamTypes.size();
            while (true) {
                if (i >= x) {
                    Method m = clazz.getMethod(this.javaMethod.getValue(), paramTypes);
                    if (!Modifier.isStatic(m.getModifiers())) {
                        issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, String.valueOf(this.javaMethod.getValue()) + " must be static!", this.javaMethod));
                    }
                    if (!Modifier.isPublic(m.getModifiers())) {
                        issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, String.valueOf(this.javaMethod.getValue()) + " must be public!", this.javaMethod));
                    }
                    return m;
                }
                Identifier javaParamType = this.javaParamTypes.get(i);
                paramTypes[i] = ResourceLoaderFactory.createResourceLoader().loadClass(javaParamType.getValue());
                if (paramTypes[i] == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, javaParamType.getValue(), javaParamType));
                    return null;
                }
                ++i;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, this.javaMethod.getValue(), this.javaMethod));
            return null;
        }
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "A return type must be specified for java extensions!", this));
        }
        this.getJavaMethod(ctx, issues);
    }

    @Override
    protected Type internalGetReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "A return type must be specified for java extensions!", this));
            return null;
        }
        return ctx.getTypeForName(this.returnType.getValue());
    }
}

