/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jet.internal.xpath.inspectors.jdt.ASTNodeDocumentRoot;

public abstract class NonDescriptorAttribute {
    private static final String NODE_TYPE_ATTR = "nodeType";
    private static final String SOURCE_ATTR = "source";
    private static final String START_POSITION_ATTR = "startPosition";
    private static final String LENGTH_ATTR = "length";
    private final ASTNode node;

    public static NonDescriptorAttribute getAttribute(ASTNode astNode, String propertyName) {
        if (LENGTH_ATTR.equals(propertyName)) {
            return new Length(astNode);
        }
        if (START_POSITION_ATTR.equals(propertyName)) {
            return new StartPosition(astNode);
        }
        if (SOURCE_ATTR.equals(propertyName)) {
            return new Source(astNode);
        }
        if (NODE_TYPE_ATTR.equals(propertyName)) {
            return new NodeType(astNode);
        }
        return null;
    }

    public static List getAttributes(ASTNode astNode) {
        ArrayList<NonDescriptorAttribute> result = new ArrayList<NonDescriptorAttribute>(4);
        result.add(NonDescriptorAttribute.getAttribute(astNode, START_POSITION_ATTR));
        result.add(NonDescriptorAttribute.getAttribute(astNode, LENGTH_ATTR));
        result.add(NonDescriptorAttribute.getAttribute(astNode, SOURCE_ATTR));
        result.add(NonDescriptorAttribute.getAttribute(astNode, NODE_TYPE_ATTR));
        return result;
    }

    public NonDescriptorAttribute(ASTNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.node = node;
    }

    public ASTNode getParent() {
        return this.node;
    }

    public abstract String getName();

    public abstract String getValue();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonDescriptorAttribute)) {
            return false;
        }
        NonDescriptorAttribute other = (NonDescriptorAttribute)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.node.equals((Object)other.node);
    }

    public static final class Length
    extends NonDescriptorAttribute {
        public Length(ASTNode node) {
            super(node);
        }

        public String getName() {
            return NonDescriptorAttribute.LENGTH_ATTR;
        }

        public String getValue() {
            return Integer.toString(this.getParent().getLength());
        }
    }

    public static final class NodeType
    extends NonDescriptorAttribute {
        public NodeType(ASTNode node) {
            super(node);
        }

        public String getName() {
            return NonDescriptorAttribute.NODE_TYPE_ATTR;
        }

        public String getValue() {
            String name = ASTNode.nodeClassForType((int)this.getParent().getNodeType()).getName();
            int lastDot = name.lastIndexOf(46);
            return name.substring(lastDot + 1);
        }
    }

    public static final class Source
    extends NonDescriptorAttribute {
        public Source(ASTNode node) {
            super(node);
        }

        public String getName() {
            return NonDescriptorAttribute.SOURCE_ATTR;
        }

        public String getValue() {
            ASTNode astNode = this.getParent();
            ASTNodeDocumentRoot documentRoot = ASTNodeDocumentRoot.documentRootFor(astNode);
            int start = astNode.getStartPosition();
            int end = start + astNode.getLength();
            return documentRoot.stringValue().substring(start, end);
        }
    }

    public static final class StartPosition
    extends NonDescriptorAttribute {
        public StartPosition(ASTNode node) {
            super(node);
        }

        public String getName() {
            return NonDescriptorAttribute.START_POSITION_ATTR;
        }

        public String getValue() {
            return Integer.toString(this.getParent().getStartPosition());
        }
    }
}

