/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;

public class BooleanFunction
implements XPathFunction {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("boolean", null, new BooleanFunction(), 1, 1);

    public Object evaluate(List args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException();
        }
        return BooleanFunction.evaluate(args.get(0));
    }

    public static boolean evaluate(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isNaN(d)) {
                return false;
            }
            return d != 0.0 && d != 0.0;
        }
        if (value instanceof NodeSet) {
            return ((NodeSet)value).size() > 0;
        }
        return false;
    }
}

