/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath.inspector;

public final class ExpandedName {
    private static final String STAR = "*";
    public static final ExpandedName ALL = new ExpandedName("*");
    private final String namespaceURI;
    private final String localPart;
    private final boolean wild;
    private final boolean localWild;

    public ExpandedName(String localPart) {
        this(null, localPart);
    }

    public ExpandedName(String namespaceURI, String localPart) {
        if (localPart == null) {
            throw new NullPointerException("localPart");
        }
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
        this.wild = namespaceURI == null && STAR.equals(localPart);
        this.localWild = namespaceURI != null && STAR.equals(localPart);
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public boolean equals(Object other) {
        if (other instanceof ExpandedName) {
            ExpandedName otherEN = (ExpandedName)other;
            if (this.wild || otherEN.wild) {
                return true;
            }
            boolean sameNamespace = false;
            if (this.namespaceURI == null && otherEN.namespaceURI == null) {
                sameNamespace = true;
            } else if (this.namespaceURI != null && this.namespaceURI.equals(otherEN.namespaceURI)) {
                sameNamespace = true;
            }
            return sameNamespace && (this.localWild || otherEN.localWild || this.localPart.equals(otherEN.localPart));
        }
        return false;
    }

    public int hashCode() {
        return (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode()) + 13 * this.localPart.hashCode();
    }

    public String toString() {
        return this.namespaceURI == null ? this.localPart : String.valueOf(this.namespaceURI) + ":" + this.localPart;
    }

    public boolean hasWildCards() {
        return this.wild || this.localWild;
    }
}

