/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.ui.newproject;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jet.ui.newproject.NewProjectInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String NEW_PROJECT_WIZARD_TX_ID = "org.eclipse.jet.transforms.newproject";
    private WizardNewProjectCreationPage projectPage;
    protected final NewProjectInfo newProjectInfo = new NewProjectInfo();

    public NewProjectWizard() {
        this.setWindowTitle(Messages.NewProjectWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("/icons/JET2ProjectWizardBanner.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IStatus result = JET2Platform.runTransformOnString((String)NewProjectWizard.NEW_PROJECT_WIZARD_TX_ID, (String)NewProjectWizard.this.getBuildModel(), (String)"xml", (IProgressMonitor)monitor);
                    if (!result.isOK()) {
                        InternalJET2Platform.log((IStatus)result);
                        new ErrorDialog(NewProjectWizard.this.getShell(), NewProjectWizard.this.getWindowTitle(), Messages.NewProjectWizard_ErrorInJETTransform, result, 6).open();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            InternalJET2Platform.logError((String)Messages.NewProjectWizard_ErrorCreatingProject, (Exception)e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected final String getBuildModel() {
        this.newProjectInfo.setProjectName(this.projectPage.getProjectName());
        if (!this.projectPage.useDefaults()) {
            this.newProjectInfo.setLocation(this.projectPage.getLocationPath().toString());
        }
        return this.newProjectInfo.toXmlString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        this.projectPage = new WizardNewProjectCreationPage(Messages.NewProjectWizard_MainPageTabText);
        this.projectPage.setTitle(Messages.NewProjectWizard_MainPageTitle);
        this.projectPage.setDescription(Messages.NewProjectWizard_MainPageDescription);
        this.addPage((IWizardPage)this.projectPage);
    }
}

