/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.scanners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jet.internal.editor.configuration.JETTokenStyleManager;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JETJavaCodeScanner
extends BufferedRuleBasedScanner {
    private String[] javaKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while", "assert", "enum", "return"};
    private String[] javaTypes = new String[]{"class", "interface", "void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private String[] javaConstants = new String[]{"false", "null", "true"};
    private String defaultBg;

    public JETJavaCodeScanner(JETTokenStyleManager manager, String defaultBg) {
        this.defaultBg = defaultBg;
        List rules = this.createRules(manager);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    protected List createRules(JETTokenStyleManager manager) {
        ArrayList<Object> rules = new ArrayList<Object>();
        IToken token = manager.requestToken("__jet_java_string_" + this.defaultBg, "java_string", this.defaultBg, "java_string_bold", "java_string_italic", "java_string_strikethrough", "java_string_underline");
        rules.add(new SingleLineRule("'", "'", token, '\\'));
        token = manager.requestToken("__jet_java_multi_line_comment_" + this.defaultBg, "java_multi_line_comment", this.defaultBg, "java_multi_line_comment_bold", "java_multi_line_comment_italic", "java_multi_line_comment_strikethrough", "java_multi_line_comment_underline");
        MultiLineRule multiLineCommentsRule = new MultiLineRule("/*", "*/", token, '\\');
        rules.add(multiLineCommentsRule);
        token = manager.requestToken("__jet_java_single_line_comment_" + this.defaultBg, "java_single_line_comment", this.defaultBg, "java_single_line_comment_bold", "java_single_line_comment_italic", "java_single_line_comment_strikethrough", "java_single_line_comment_underline");
        SingleLineRule singleLineCommentsRule = new SingleLineRule("//", null, token);
        rules.add(singleLineCommentsRule);
        JavaWordDetector wordDetector = new JavaWordDetector();
        token = manager.requestToken("__jet_java_default_" + this.defaultBg, "java_default", this.defaultBg, "java_default_bold", "java_default_italic", "java_default_strikethrough", "java_default_underline");
        WordRule wordRule = new WordRule((IWordDetector)wordDetector, token);
        token = manager.requestToken("__jet_java_keyword_" + this.defaultBg, "java_keyword", this.defaultBg, "java_keyword_bold", "java_keyword_italic", "java_keyword_strikethrough", "java_keyword_underline");
        int i = 0;
        while (i < this.javaKeywords.length) {
            wordRule.addWord(this.javaKeywords[i], token);
            ++i;
        }
        i = 0;
        while (i < this.javaTypes.length) {
            wordRule.addWord(this.javaTypes[i], token);
            ++i;
        }
        i = 0;
        while (i < this.javaConstants.length) {
            wordRule.addWord(this.javaConstants[i], token);
            ++i;
        }
        rules.add(wordRule);
        token = manager.requestToken("__jet_java_operator_" + this.defaultBg, "java_operator", this.defaultBg, "java_operator_bold", "java_operator_italic", "java_operator_strikethrough", "java_operator_underline");
        rules.add(new OperatorRule(token));
        token = manager.requestToken("__jet_java_bracket_" + this.defaultBg, "java_bracket", this.defaultBg, "java_bracket_bold", "java_bracket_italic", "java_bracket_strikethrough", "java_bracket_underline");
        rules.add(new BracketRule(token));
        return rules;
    }

    private class BracketRule
    implements IRule {
        private char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken success;

        public BracketRule(IToken token) {
            this.success = token;
        }

        public boolean isBracket(char character) {
            int index = 0;
            while (index < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isBracket((char)character)) {
                while (this.isBracket((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.success;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private class JavaWordDetector
    implements IWordDetector {
        private JavaWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private class OperatorRule
    implements IRule {
        private char[] JAVA_OPERATORS = new char[]{';', '.', '=', '/', '\\', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

